const path = require('path');
const dotenv = require('dotenv');

dotenv.config();

module.exports = {
  target: 'node',
  mode: process.env.NODE_ENV,
  entry: {
    app: './src/index.js',
  },
  output: {
    path: path.resolve(__dirname, 'build'),
    filename: 'app.bundle.js',
  },
  node: {
    __dirname: false,
  },
  module: {
    rules: [{
      test: /\.js?$/,
      exclude: /node_modules/,
      use: {
        loader: 'babel-loader',
        options: {
          presets: ['@babel/preset-env'],
          plugins: ['@babel/plugin-transform-runtime', '@babel/plugin-transform-modules-commonjs'],
        },
      },
    }],
  },
};
