import { getApi, postApi, deleteApi } from '../../helper/index.js';
import { buildUrl } from '../url-helper.js';
import { buildHeader } from '../headers.js';

export const wixCreateRecurringChargeApi = async (body, accessToken) => {
  const url = `${process.env.WIX_API_URL + buildUrl.recurringChargeUrl}/checkout`;
  const headers = buildHeader(accessToken);
  return postApi(url, {
    headers,
  }, body);
};

export const wixGetApplicationChargeApi = async (accessToken) => {
  const url = `${process.env.WIX_API_URL + buildUrl.recurringChargeUrl}/checkout/history`;
  const headers = buildHeader(accessToken);
  return getApi(url, {
    headers,
  });
};

export const wixGetAppInstanceApi = async (accessToken) => {
  const url = `${process.env.WIX_API_URL + buildUrl.recurringChargeUrl}/instance`;
  const headers = buildHeader(accessToken);
  return getApi(url, {
    headers,
  });
};
