import { postApi } from '../../helper/index.js';
import { buildHeader } from '../headers.js';

export const wixGetRefreshToken = async (code) => {
  const { APP_ID: appId, APP_SECRET_KEY: clientSecret } = process.env;
  const body = {
    grant_type: 'authorization_code',
    client_id: appId,
    client_secret: clientSecret,
    code,
  };
  const url = `${process.env.WIX_API_URL}/oauth/access`;
  const headers = buildHeader();
  return postApi(url, {
    headers,
  }, body);
};

export const wixCreateAccessToken = async (refreshToken) => {
  const { APP_ID: appId, APP_SECRET_KEY: clientSecret } = process.env;
  const body = {
    grant_type: 'refresh_token',
    client_id: appId,
    client_secret: clientSecret,
    refresh_token: refreshToken,
  };
  const url = `${process.env.WIX_API_URL}/oauth/access`;
  const headers = buildHeader();
  return postApi(url, {
    headers,
  }, body);
};
