import { buildUrl } from '../url-helper.js';
import { buildHeader } from '../headers.js';
import { getApi } from '../../helper/index.js';

export const wixGetCustomerDataById = async (id, accessToken) => {
  const url = `${process.env.WIX_API_URL + buildUrl.customerUrl}/${id}?fieldsets=FULL`;
  const headers = buildHeader(accessToken);
  return getApi(url, {
    headers,
  });
};
