import Joi from 'joi';
import { notAcceptable, extractJoiErrorMessage } from '../helper/index.js';
import { headers } from '../constants/index.js';

export const validatePutShopRoute = (ctx) => {
  const putReqHeaderSchema = Joi.object({
    [headers.WIX_INSTANCE_ID_HEADER]: Joi.string().required().label(headers.WIX_INSTANCE_ID_HEADER),
    [headers.CH_MASTER_KEY_HEADER_NAME]: Joi.string().required().label(headers.CH_MASTER_KEY_HEADER_NAME),
  });
  const shopPutRouteSchema = Joi.object({
    chApplicationId: Joi.string().required().label('chApplicationId'),
    chPublicKey: Joi.string().required().label('chPublicKey'),
    chPrivateKey: Joi.string().required().label('chPrivateKey'),
    chCustomerId: Joi.string().required().label('chCustomerId'),
  });
  const options = {
    allowUnknown: true, // ignore unknown props
  };
  const headerError = putReqHeaderSchema.validate(ctx.headers, options).error;
  if (headerError) {
    const errorMessage = extractJoiErrorMessage(headerError);
    throw notAcceptable(errorMessage);
  }

  const bodyError = shopPutRouteSchema.validate(ctx.request.body).error;
  if (bodyError) {
    const errorMessage = extractJoiErrorMessage(bodyError);
    throw notAcceptable(errorMessage);
  }
};
