import Joi from 'joi';
import { notAcceptable, extractJoiErrorMessage } from '../helper/index.js';

export const validateGetProductsRoute = (ctx) => {
  const productsQueryParamsSchema = Joi.object({
    ids: Joi.string().optional().label('ids'),
  });

  const queryParamsValidationResult = productsQueryParamsSchema.validate(ctx.request.query).error;
  if (queryParamsValidationResult) {
    const errorMessage = extractJoiErrorMessage(queryParamsValidationResult);
    throw notAcceptable(errorMessage);
  }
};
