import Joi from 'joi';
import { headers } from '../constants/index.js';
import { notAcceptable, extractJoiErrorMessage } from '../helper/index.js';

export const validateGetChannelizeDataRoute = (ctx) => {
  const tokenRouteSchema = Joi.object({
    [headers.WIX_INSTANCE_ID_HEADER]: Joi.string().required().label(headers.WIX_INSTANCE_ID_HEADER),
  });
    // TODO: test after remove allowUnknown
  const options = {
    allowUnknown: true, // ignore unknown props
  };

  const { value, error } = tokenRouteSchema.validate(ctx.headers, options);
  if (error) {
    const errorMessage = extractJoiErrorMessage(error);
    throw notAcceptable(errorMessage);
  }
};
