import Joi from 'joi';
import { notAcceptable, extractJoiErrorMessage } from '../helper/index.js';

export const validateRecurringChargeRoute = (ctx) => {
  const applicationChargeRouteSchema = Joi.object({
    productId: Joi.string().required().label('productId'),
    successUrl: Joi.string().required().label('successUrl'),
    testCheckout: Joi.boolean().optional().default(false),
    billingCycle: Joi.string().required().label('billingCycle'),
  });
  const bodyError = applicationChargeRouteSchema.validate(ctx.request.body).error;
  if (bodyError) {
    const errorMessage = extractJoiErrorMessage(bodyError);
    throw notAcceptable(errorMessage);
  }
};
