import Router from 'koa-router';
import { webhooksEndpoint, statusCode } from '../constants/index.js';
import { successHandler, logger } from '../helper/index.js';
import {
  createdCustomerHandler, updatedCustomerHandler, deletedCustomerHandler, appUninstallHandler, paidPlanAutoRenewalCancelled,
} from '../controller/index.js';

const webhooksRoute = new Router();

webhooksRoute.post(`${webhooksEndpoint.CUSTOMER_CREATE_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug(`Entering: ${webhooksEndpoint.CUSTOMER_CREATE_ENDPOINT} api route`);
    const responseData = await createdCustomerHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(responseData);
  } catch (err) {
    // errorHandler(ctx, err);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(null, 'api run successfully');
  }
});

webhooksRoute.post(`${webhooksEndpoint.CUSTOMER_UPDATE_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug(`Entering: ${webhooksEndpoint.CUSTOMER_UPDATE_ENDPOINT} api route`);
    await updatedCustomerHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler('data updated successfully');
  } catch (err) {
    // errorHandler(ctx, err);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(null, 'api run successfully');
  }
});

webhooksRoute.post(`${webhooksEndpoint.CUSTOMER_DELETE_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug(`Entering: ${webhooksEndpoint.CUSTOMER_DELETE_ENDPOINT} api route`);
    await deletedCustomerHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler('user deleted succesfully');
  } catch (err) {
    // errorHandler(ctx, err);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(null, 'api run successfully');
  }
});

webhooksRoute.post(`${webhooksEndpoint.APP_UNINSTALL_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug(`Entering: ${webhooksEndpoint.APP_UNINSTALL_ENDPOINT} api route`);
    const responseData = await appUninstallHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(responseData);
  } catch (err) {
    // errorHandler(ctx, err);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(null, 'api run successfully');
  }
});

webhooksRoute.post(`${webhooksEndpoint.PLAN_AUTORENEWAL_CANCELLED_ENDPOINTS}`, async (ctx) => {
  try {
    logger.debug(`Entering: ${webhooksEndpoint.PLAN_AUTORENEWAL_CANCELLED_ENDPOINTS} api route`);
    const responseData = await paidPlanAutoRenewalCancelled(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(responseData);
  } catch (err) {
    // errorHandler(ctx, err);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(null, 'api run successfully');
  }
});

export default webhooksRoute;
