import Router from 'koa-router';
import { successHandler, errorHandler, logger } from '../helper/index.js';
import { shopEndPoints, statusCode } from '../constants/index.js';
import { validatePutShopRoute } from '../validators/index.js';
import { updateShopHandler } from '../controller/index.js';

const shopRoute = new Router();

shopRoute.put(`${shopEndPoints.SHOP_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug('Entering: Put shop api route');
    validatePutShopRoute(ctx);
    await updateShopHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler('data updated successfully');
  } catch (err) {
    errorHandler(ctx, err);
  }
});

export default shopRoute;
