import Router from 'koa-router';
import { successHandler, errorHandler, logger } from '../helper/index.js';
import { productsEndpoints, statusCode } from '../constants/index.js';
import { getProductsHandler } from '../controller/index.js';
import { validateGetProductsRoute } from '../validators/index.js';

const productRoute = new Router();

productRoute.get(`${productsEndpoints.GET_PRODUCTS_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug('Entering: Get products api route');
    validateGetProductsRoute(ctx);
    const productResponse = await getProductsHandler(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(productResponse);
  } catch (err) {
    errorHandler(ctx, err);
  }
});

export default productRoute;
