import Router from 'koa-router';
import { errorHandler, getAccessToken, getDashboardUrl, logger } from '../helper/index.js';
import {
  getWixInstallUrl, registerShop, getRedirectUrl, getPricingPage,
} from '../controller/index.js';

const installRoute = new Router();

installRoute.get('/', async (ctx) => {
  try {
    logger.debug('Entering: getWixInstallUrl api route');
    const url = await getWixInstallUrl(ctx);
    ctx.redirect(url);
  } catch (error) {
    errorHandler(ctx, error);
  }
});

installRoute.get('/auth', async (ctx) => {
  try {
    logger.debug('Entering: registerShop api route');
    const { WIX_URL: url } = process.env;
    const shopId = await registerShop(ctx);
    const accessToken = await getAccessToken(shopId);
    ctx.redirect(`${url}/installer/close-window?access_token=${accessToken}`);
  } catch (error) {
    errorHandler(ctx, error);
  }
});

installRoute.get('/redirect', async (ctx) => {
  try {
    logger.debug('Entering: getRedirectUrl api route');
    const instanceId = await getRedirectUrl(ctx);
    const redirectUrl = getDashboardUrl(instanceId);
    ctx.redirect(redirectUrl);
  } catch (error) {
    errorHandler(ctx, error);
  }
});

installRoute.get('/redirect/pricing', async (ctx) => {
  try {
    logger.debug('Entering: Pricing Page api route');
    const url = await getPricingPage(ctx);
    ctx.redirect(url);
  } catch (error) {
    errorHandler(ctx, error);
  }
});

export default installRoute;
