import Router from 'koa-router';
import { streamPageEndpoints, statusCode } from '../constants/index.js';
import { successHandler, errorHandler, logger } from '../helper/index.js';
import { getChannelizeData } from '../controller/index.js';
import { validateGetChannelizeDataRoute } from '../validators/index.js';

const channelizeRoute = new Router();

channelizeRoute.get(`${streamPageEndpoints.GET_CHANNELIZE_DATA}`, async (ctx) => {
  try {
    logger.debug('Entering: getChannelizeData api route');
    validateGetChannelizeDataRoute(ctx);
    const loginTokenResponse = await getChannelizeData(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(loginTokenResponse);
  } catch (err) {
    errorHandler(ctx, err);
  }
});

export default channelizeRoute;
