import Router from 'koa-router';
import { applicationChargeEndpoint, statusCode } from '../constants/index.js';
import { successHandler, errorHandler, logger } from '../helper/index.js';
import { getApplicationCharge, createRecurringCharge, getAppInstance } from '../controller/index.js';
import { validateRecurringChargeRoute } from '../validators/index.js';

const applicationChargeRoute = new Router();

applicationChargeRoute.post(`${applicationChargeEndpoint.RECURRING_CHARGE_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug('Entering: createRecurringCharge api route');
    validateRecurringChargeRoute(ctx);
    const createRecurringChargeResponse = await createRecurringCharge(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(createRecurringChargeResponse);
  } catch (err) {
    errorHandler(ctx, err);
  }
});

applicationChargeRoute.get(`${applicationChargeEndpoint.RECURRING_CHARGE_ENDPOINT}`, async (ctx) => {
  try {
    logger.debug('Entering: getApplicationCharge api route');
    const getApplicationChargeResponse = await getApplicationCharge(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(getApplicationChargeResponse);
  } catch (err) {
    errorHandler(ctx, err);
  }
});

applicationChargeRoute.get(`${applicationChargeEndpoint.APP_INSTANCE_ENDPOINS}`, async (ctx) => {
  try {
    logger.debug('Entering: app Instance api route');
    const appInstanceResponse = await getAppInstance(ctx);
    ctx.status = statusCode.OK;
    ctx.body = successHandler(appInstanceResponse);
  } catch (err) {
    errorHandler(ctx, err);
  }
});

export default applicationChargeRoute;
