import mongoose from 'mongoose';
import { v4 as uuidv4 } from 'uuid';
import { Collections } from '../constants/index.js';

const Schema = mongoose.Schema;
export const wixTokenSchema = new Schema({
  _id: {
    type: String,
    default: function genUUID() {
      return uuidv4();
    },
  },
  shop_id_fk: {
    type: String,
    required: true,
    max: 100,
  },
  refresh_token: {
    type: String,
    required: true,
    unique: true,
    max: 500,
  },
  created_at: {
    type: Date,
    default: Date.now,
  },
  updated_at: {
    type: Date,
    default: Date.now,
  },
}, { versionKey: false });

export const WixTokenModel = mongoose.model(Collections.WIX_TOKENS, wixTokenSchema);
