import mongoose from 'mongoose';
import { v4 as uuidv4 } from 'uuid';
import { Collections } from '../constants/index.js';

const Schema = mongoose.Schema;
export const shopSchema = new Schema({
  _id: {
    type: String,
    default: function genUUID() {
      return uuidv4();
    },
  },
  instance_id: {
    type: String,
    required: true,
    unique: true,
    max: 100,
  },
  ch_application_id: {
    type: String,
    required: false,
    max: 100,
  },
  ch_public_key: {
    type: String,
    required: false,
    max: 100,
  },
  ch_private_key: {
    type: String,
    required: false,
    max: 100,
  },
  ch_customer_id: {
    type: String,
    required: false,
    max: 100,
  },
  is_app_uninstalled: {
    type: Boolean,
    default: false,
  },
  created_at: {
    type: Date,
    default: Date.now,
  },
  updated_at: {
    type: Date,
    default: Date.now,
  },
}, { versionKey: false });

export const ShopModel = mongoose.model(Collections.SHOPS, shopSchema);
