import * as dotenv from 'dotenv';
import Koa from 'koa';
import * as Sentry from '@sentry/node';
import bodyParser from 'koa-bodyparser';
import session from 'koa-session';
import cors from '@koa/cors';
import mongoose from 'mongoose';
import { routes } from './routes/index.js';
import { authMiddleware } from './middleware/index.js';
import { logger } from './helper/index.js';

dotenv.config();

const port = parseInt(process.env.PORT, 10) || 3000;
const server = new Koa();
server.use(cors());
server.use(session(server));

server.use(bodyParser({
  enableTypes: ['json', 'form', 'text'],
}));
server.use(authMiddleware);
routes(server);

// Set up mongoose connection
mongoose.connect(process.env.MONGODB_URL);
mongoose.connection.once('open', () => {
  logger.info('conneted to database');
}).on('error', (error) => {
  logger.error('db error: ', { messageObject: error });
});

server.on('error', async (error) => {
  logger.error('captured error:', { messageObject: error });
  if (error && error.statusCode >= 500 && error.statusCode < 600) {
    Sentry.captureException(error);
  }
});

server.listen(port, () => {
  logger.debug(`> Ready on http://localhost:${port}`);
});
