import { Buffer } from 'buffer';
import { channelizeWebsiteEndpoint, headers } from '../constants/index.js';

export const extractJoiErrorMessage = (joiErrorObj) => {
  const errorMessage = (joiErrorObj && joiErrorObj.output && joiErrorObj.output.payload
     && joiErrorObj.output.payload && joiErrorObj.output.payload.message) || 'This request is unauthorized';
  return errorMessage;
};

export const getDashboardUrl = (instanceId) => `${process.env.CHANNELIZE_WEBSITE_HOST}${channelizeWebsiteEndpoint.LOGIN}?source=wix&instanceId=${instanceId}`;

export const createChannelizeHeader = (chPrivateKey) => {
  const privateKeyBuffer = new Buffer.from(chPrivateKey);
  return {
    'Content-Type': 'application/json',
    Authorization: `Basic ${privateKeyBuffer.toString('base64')}`,
  };
};

export const getHeaders = (ctx) => {
  const headersObj = {
    instanceId: ctx.headers[headers.WIX_INSTANCE_ID_HEADER],
    chMasterKey: ctx.headers[headers.CH_MASTER_KEY_HEADER_NAME],
    wixUserId: ctx.headers[headers.WIX_USER_ID_HEADER],

  };
  Object.keys(headersObj).forEach((key) => {
    if (headersObj[key] === undefined || headersObj[key] === null) {
      delete headersObj[key];
    }
  });
  return headersObj;
};
