import { statusCode as defaultStatusCode, responseCode } from '../constants/index.js';

export const errorResponseHandler = (boomErrorObj) => {
  const errorResponse = {};
  const boomErrorPayload = (boomErrorObj && boomErrorObj.output && boomErrorObj.output.payload) || {};
  errorResponse.statusCode = boomErrorPayload.statusCode || 500;
  errorResponse.error = boomErrorPayload.error || boomErrorObj.message || 'Internal Server Error';
  errorResponse.message = boomErrorPayload.message || boomErrorObj.message || 'Internal Server Error';
  return errorResponse;
};

export const successHandler = (
  data = undefined,
  message,
  statusCode = defaultStatusCode.OK,
  success = responseCode.OK,
) => {
  const responseObj = {
    statusCode,
    success,
    data,
    message,
  };
  return responseObj;
};

export const errorHandler = (ctx, err) => {
  ctx.status = err.statusCode;
  ctx.body = err;
  ctx.app.emit('error', err, ctx);
};
