import { createLogger, format, transports } from 'winston';
import crypto from 'crypto';
import dotenv from 'dotenv';

const WinstonCloudWatch = require('winston-cloudwatch');

dotenv.config();

const getTransports = () => {
  const transportsArray = [];
  const {
    IS_CONSOLE_LOG_ENABLED: isConsoleLogEnabled = true, IS_CLOUDWATCH_LOG_ENABLED: isCloudWatchLogEnabled = true, APP_ENV, APP_TYPE,
  } = process.env;
  if (isConsoleLogEnabled === 'true' || isConsoleLogEnabled === true) {
    transportsArray.push(new transports.Console());
  }
  if (isCloudWatchLogEnabled === 'true' || isCloudWatchLogEnabled === true) {
    const startTime = new Date().toISOString();
    const logGroupName = `channelize-wix-app-backend/${APP_TYPE}/${APP_ENV}`;
    const cloudwatchConfig = {
      level: 'debug',
      logGroupName,
      logStreamName() {
        const date = new Date().toISOString().split('T')[0];
        return `${date}-${crypto.createHash('md5').update(startTime).digest('hex')}`;
      },
      // awsAccessKeyId: process.env.AWS_ACCESS_KEY_ID,
      // awsSecretKey: process.env.AWS_SECRET_ACCESS_KEY,
      awsRegion: process.env.AWS_REGION,
      messageFormatter: ({ level, message, messageObject }) => {
        let logMessage = `[${level}] : ${message}`;
        if (messageObject) {
          logMessage += `\n ${JSON.stringify(messageObject)}`;
        }
        return logMessage;
      },
    };
    transportsArray.push(new WinstonCloudWatch(cloudwatchConfig));
  }
  return transportsArray;
};

export const logger = createLogger({
  format: format.json(),
  transports: getTransports(),
});
