import { statusCode, responseCode } from '../constants/index.js';

export const badRequest = (message) => {
  if (!message) {
    message = 'Bad Request';
  }
  const e = {};
  e.statusCode = statusCode.BAD_REQUEST;
  e.error = responseCode.BAD_REQUEST;
  e.message = message;
  return e;
};

export const unauthorized = (message) => {
  if (!message) {
    message = 'Unauthorized';
  }
  const e = {};
  e.statusCode = statusCode.UNAUTHORIZED;
  e.error = responseCode.UNAUTHORIZED;
  e.message = message;
  return e;
};

export const forbidden = (message) => {
  if (!message) {
    message = 'Forbidden';
  }
  const e = {};
  e.statusCode = statusCode.FORBIDDEN;
  e.error = responseCode.FORBIDDEN;
  e.message = message;
  return e;
};

export const notFound = (message) => {
  if (!message) {
    message = 'Not Found';
  }
  const e = {};
  e.statusCode = statusCode.NOT_FOUND;
  e.error = responseCode.NOT_FOUND;
  e.message = message;
  return e;
};

export const notAcceptable = (message) => {
  if (!message) {
    message = 'Not Acceptable';
  }
  const e = {};
  e.statusCode = statusCode.NOT_ACCEPTABLE;
  e.error = responseCode.NOT_ACCEPTABLE;
  e.message = message;
  return e;
};

export const failedDependency = (message) => {
  if (!message) {
    message = 'Failed Dependency';
  }
  const e = {};
  e.statusCode = statusCode.FAILED_DEPENDENCY;
  e.error = responseCode.FAILED_DEPENDENCY;
  e.message = message;
  return e;
};

export const badImplementation = (message) => {
  if (!message) {
    message = 'Internal Server Error';
  }
  const e = {};
  e.statusCode = statusCode.INTERNAL_SERVER_ERROR;
  e.error = responseCode.INTERNAL_SERVER_ERROR;
  e.message = message;
  return e;
};
