import {
  unauthorized, badImplementation, findOne, notFound,
} from './index.js';
import { Collections } from '../constants/index.js';

var file = require('file-system');
var jwt = require('jsonwebtoken');

const { NODE_ENV } = process.env;

export const authorizeInstanceIdAndMasterKey = async (instanceId, chMasterKey) => {
  const shopData = await authorizeInstanceId(instanceId);
  if (!isMasterKeyValid(chMasterKey)) {
    throw unauthorized('data not authorize');
  }
  return shopData;
};

export const authorizeInstanceId = async (instanceId) => {
  if (!instanceId) {
    throw unauthorized('data not authorize');
  }
  const shopData = await findOne(Collections.SHOPS, { instanceId, isAppUninstalled: false });
  if (!shopData) {
    throw unauthorized('data not authorize');
  }
  return shopData;
};

export const authorizeWebhooks = async (token) => {
  var publicKey = file.readFileSync(`public.${NODE_ENV}.pem`, 'utf8');
  const payload = jwt.verify(token, publicKey, { algorithms: ['RS256'] }, (err, decoded) => {
    if (err) {
      throw notFound('webhooks not verified: ', err);
    }
    return decoded;
  });
  return payload;
};

const isMasterKeyValid = (encodedChMasterKey) => {
  const decodedMasterKey = Buffer.from(encodedChMasterKey, 'base64').toString();
  let { MASTER_KEY } = process.env;
  if (!MASTER_KEY || typeof (MASTER_KEY) !== 'string') {
    throw badImplementation('missing master key');
  }
  MASTER_KEY = MASTER_KEY.trim();
  return MASTER_KEY === decodedMasterKey;
};
