import axios from 'axios';
import { badRequest } from './errors.js';
import { logger } from './index.js';

const config = {};

export function _mergeConfig(config, incomingConfig) {
  config.headers = config.headers || {};
  incomingConfig = incomingConfig || {};
  incomingConfig.headers = incomingConfig.headers || {};
  return {
    ...config,
    ...incomingConfig,
    headers: {
      ...config.headers,
      ...incomingConfig.headers,
    },
  };
}

export const getApi = async (url, incomingConfig) => {
  try {
    if (!url) { return badRequest('URL is not defined'); }
    const res = await axios.get(url, _mergeConfig(config, incomingConfig));
    return res;
  } catch (err) {
    logger.error(`getApi: url: ${url}, ${err.message}`);
    return err;
  }
};

export const postApi = async (url, incomingConfig, payload = {}) => {
  try {
    if (!url) { return badRequest('URL is not defined'); }
    if (!payload) { return badRequest('Payload is not defined'); }
    const res = await axios.post(url, payload, _mergeConfig(config, incomingConfig));
    return res;
  } catch (err) {
    logger.error(`postApi: url: ${url}, ${err.message}`);
    return err;
  }
};

export const putApi = async (url, incomingConfig, payload = {}) => {
  try {
    if (!url) { return badRequest('URL is not defined'); }
    if (!payload) { return badRequest('Payload is not defined'); }
    const res = await axios.put(url, payload, _mergeConfig(config, incomingConfig));
    return res;
  } catch (err) {
    logger.error(`putApi: url: ${url}, ${err.message}`);
    return err;
  }
};

export const deleteApi = async (url, incomingConfig) => {
  try {
    if (!url) { return badRequest('URL is not defined'); }
    const res = await axios.delete(url, _mergeConfig(config, incomingConfig));
    return res;
  } catch (err) {
    logger.error(`deleteApi: url: ${url}, ${err.message}`);
    return err;
  }
};
