import { Collections } from '../constants/index.js';
import { findOne, notFound, unauthorized } from './index.js';
import { wixCreateAccessToken } from '../wix/resources/install-resource.js';

export const getAccessToken = async (shopIdFk) => {
  try {
    const shopId = await findOne(Collections.WIX_TOKENS, { shopIdFk });
    if (!shopId) {
      throw notFound('shopId not found');
    }
    const result = await wixCreateAccessToken(shopId.refresh_token);
    if (!result.data.access_token) {
      throw notFound('access not found');
    }
    return result.data.access_token;
  } catch (error) {
    throw unauthorized('Access Token not created');
  }
};
