import { Collections } from '../constants/index.js';
import {
  getHeaders, updateAll, unauthorized, logger
} from '../helper/index.js';

export const updateShopHandler = async (ctx) => {
  try {
    logger.debug('Entering: updateShopHandler');
    const { instanceId } = getHeaders(ctx);
    const {
      chApplicationId, chPublicKey, chPrivateKey, chCustomerId,
    } = ctx.request.body;
    const updatedResponse = await updateAll(Collections.SHOPS, { instanceId }, {
      chApplicationId,
      chPublicKey,
      chPrivateKey,
      chCustomerId,
    });
    return updatedResponse;
  } catch (error) {
    logger.error('updateShopHandler controller error: ', { messageObject: error });
    throw unauthorized('shop data is not authorized');
  }
};
