import {
  getAccessToken, failedDependency, unauthorized, logger
} from '../helper/index.js';
import { wixGetProductsHandlerApi } from '../wix/resources/index.js';

export const getProductsHandler = async (ctx) => {
  try {
    logger.debug('Entering getProductsHandler Api');
    const { _id: shopIdFk } = ctx.request.shopData;
    const accessToken = await getAccessToken(shopIdFk);
    const { ids } = ctx.request.query;
    const body = await stringToProductIds(ids);
    const productsResponse = await wixGetProductsHandlerApi(body, accessToken);
    if (productsResponse.response && productsResponse.response.data) {
      logger.debug('getProductsHelper error: ', productsResponse.response.data);
      throw failedDependency('failedDependency');
    }

    return productsResponse.data;
  } catch (error) {
    logger.error('getProductHandler controller error :', { messageObject: error });
    throw unauthorized('data not found');
  }
};
// converting string ids in array
export const stringToProductIds = async (ids) => {
  if (!ids) {
    return;
  }
  const idSplits = ids.split(',');
  const idArray = [];
  idSplits.forEach((item) => {
    idArray.push(`"${item}"`);
  });
  var data = {
    query: {
      filter: `{\"id\": {\"$hasSome\": [${idArray}]}}`,
    },
  };

  return data;
};
