import {
  getAccessToken, failedDependency, unauthorized, logger
} from '../helper/index.js';
import { wixCreateRecurringChargeApi, wixGetApplicationChargeApi, wixGetAppInstanceApi } from '../wix/resources/index.js';

export const getApplicationCharge = async (ctx) => {
  try {
    logger.debug('Entering getApplicationCharge Api');
    const { _id: shopIdFk } = ctx.request.shopData;
    const accessToken = await getAccessToken(shopIdFk);
    const recurringChargesResponse = await wixGetApplicationChargeApi(accessToken);
    if (recurringChargesResponse && recurringChargesResponse.response) {
      const response = recurringChargesResponse.response;
      if (response.status < 200 || response.status > 299) {
        throw failedDependency('failed wix api');
      }

      if (response.data) {
        throw failedDependency('failed wix api');
      }
    }
    return recurringChargesResponse.data;
  } catch (error) {
    logger.error('getApplicationCharge controller error :', { messageObject: error});
    throw unauthorized('getApplicationCharge is not authorized');
  }
};
export const createRecurringCharge = async (ctx) => {
  try {
    logger.debug('Entering createRecurringCharge Api');
    const { _id: shopIdFk } = ctx.request.shopData;
    const accessToken = await getAccessToken(shopIdFk);
    const {
      productId, successUrl, testCheckout, billingCycle,
    } = ctx.request.body;
    const body = {
      productId,
      successUrl,
      testCheckout,
      billingCycle,
    };
    const createdPlanResponse = await wixCreateRecurringChargeApi(body, accessToken);
    if (createdPlanResponse && createdPlanResponse.response) {
      const response = createdPlanResponse.response;
      if (response.status < 200 || response.status > 299) {
        throw failedDependency('failed wix api');
      }

      if (response.data) {
        throw failedDependency('failed wix api');
      }
    }
    return createdPlanResponse.data;
  } catch (error) {
    logger.error('createRecurringCharge controller error :',  { messageObject: error});
    throw unauthorized('createRecurringCharge is not authorized');
  }
};

export const getAppInstance = async (ctx) => {
  try {
    logger.debug('Entering getAppInstance Api');
    const { _id: shopIdFk } = ctx.request.shopData;
    const accessToken = await getAccessToken(shopIdFk);
    const appInstanceResponse = await wixGetAppInstanceApi(accessToken);
    if (appInstanceResponse && appInstanceResponse.response) {
      const response = appInstanceResponse.response;
      if (response.status < 200 || response.status > 299) {
        throw failedDependency('failed wix api');
      }

      if (response.data) {
        throw failedDependency('failed wix api');
      }
    }
    return appInstanceResponse.data;
  } catch (error) {
    logger.error('getAppInstance controller error :',  { messageObject: error});
    throw unauthorized('getAppInstance is not authorized');
  }
};
