"use strict";
/**
 * @packageDocumentation
 * @module mqtt5
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.transform_mqtt_js_unsuback_to_crt_unsuback = exports.transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options = exports.transform_mqtt_js_puback_to_crt_puback = exports.transform_mqtt_js_publish_to_crt_publish = exports.transform_crt_publish_to_mqtt_js_publish_options = exports.transform_mqtt_js_subscription_grants_to_crt_suback = exports.transform_mqtt_js_suback_to_crt_suback = exports.transform_crt_subscribe_to_mqtt_js_subscribe_options = exports.transform_crt_subscribe_to_mqtt_js_subscription_map = exports.transform_mqtt_js_disconnect_to_crt_disconnect = exports.transform_crt_disconnect_to_mqtt_js_disconnect = exports.transform_mqtt_js_user_properties_to_crt_user_properties = exports.transform_crt_user_properties_to_mqtt_js_user_properties = exports.create_mqtt_js_client_config_from_crt_client_config = exports.compute_mqtt_js_reconnect_delay_from_crt_max_delay = exports.getOrderedReconnectDelayBounds = exports.create_negotiated_settings = exports.transform_mqtt_js_connack_to_crt_connack = exports.DEFAULT_MIN_CONNECTED_TIME_TO_RESET_RECONNECT_DELAY_MS = exports.DEFAULT_MAX_RECONNECT_DELAY_MS = exports.DEFAULT_MIN_RECONNECT_DELAY_MS = exports.DEFAULT_CONNECT_TIMEOUT_MS = exports.DEFAULT_RECEIVE_MAXIMUM = exports.MAXIMUM_PACKET_SIZE = exports.MAXIMUM_VARIABLE_LENGTH_INTEGER = void 0;
var mqtt_shared = __importStar(require("../common/mqtt_shared"));
var mqtt5 = __importStar(require("./mqtt5"));
var utils = __importStar(require("../common/utils"));
var error_1 = require("./error");
exports.MAXIMUM_VARIABLE_LENGTH_INTEGER = 268435455;
exports.MAXIMUM_PACKET_SIZE = 5 + exports.MAXIMUM_VARIABLE_LENGTH_INTEGER;
exports.DEFAULT_RECEIVE_MAXIMUM = 65535;
exports.DEFAULT_CONNECT_TIMEOUT_MS = 30000;
exports.DEFAULT_MIN_RECONNECT_DELAY_MS = 1000;
exports.DEFAULT_MAX_RECONNECT_DELAY_MS = 120000;
exports.DEFAULT_MIN_CONNECTED_TIME_TO_RESET_RECONNECT_DELAY_MS = 30000;
/** @internal */
function transform_mqtt_js_connack_to_crt_connack(mqtt_js_connack) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
    if (mqtt_js_connack == null || mqtt_js_connack == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_connack_to_crt_connack: mqtt_js_connack not defined");
    }
    var connack = {
        type: mqtt5.PacketType.Connack,
        sessionPresent: mqtt_js_connack.sessionPresent,
        reasonCode: (_a = mqtt_js_connack.reasonCode) !== null && _a !== void 0 ? _a : mqtt5.ConnectReasonCode.Success
    };
    utils.set_defined_property(connack, "sessionExpiryInterval", (_b = mqtt_js_connack.properties) === null || _b === void 0 ? void 0 : _b.sessionExpiryInterval);
    utils.set_defined_property(connack, "receiveMaximum", (_c = mqtt_js_connack.properties) === null || _c === void 0 ? void 0 : _c.receiveMaximum);
    utils.set_defined_property(connack, "maximumQos", (_d = mqtt_js_connack.properties) === null || _d === void 0 ? void 0 : _d.maximumQoS);
    utils.set_defined_property(connack, "retainAvailable", (_e = mqtt_js_connack.properties) === null || _e === void 0 ? void 0 : _e.retainAvailable);
    utils.set_defined_property(connack, "maximumPacketSize", (_f = mqtt_js_connack.properties) === null || _f === void 0 ? void 0 : _f.maximumPacketSize);
    utils.set_defined_property(connack, "assignedClientIdentifier", (_g = mqtt_js_connack.properties) === null || _g === void 0 ? void 0 : _g.assignedClientIdentifier);
    utils.set_defined_property(connack, "topicAliasMaximum", (_h = mqtt_js_connack.properties) === null || _h === void 0 ? void 0 : _h.topicAliasMaximum);
    utils.set_defined_property(connack, "reasonString", (_j = mqtt_js_connack.properties) === null || _j === void 0 ? void 0 : _j.reasonString);
    utils.set_defined_property(connack, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_k = mqtt_js_connack.properties) === null || _k === void 0 ? void 0 : _k.userProperties));
    utils.set_defined_property(connack, "wildcardSubscriptionsAvailable", (_l = mqtt_js_connack.properties) === null || _l === void 0 ? void 0 : _l.wildcardSubscriptionAvailable);
    utils.set_defined_property(connack, "subscriptionIdentifiersAvailable", (_m = mqtt_js_connack.properties) === null || _m === void 0 ? void 0 : _m.subscriptionIdentifiersAvailable);
    utils.set_defined_property(connack, "sharedSubscriptionsAvailable", (_o = mqtt_js_connack.properties) === null || _o === void 0 ? void 0 : _o.sharedSubscriptionAvailable);
    utils.set_defined_property(connack, "serverKeepAlive", (_p = mqtt_js_connack.properties) === null || _p === void 0 ? void 0 : _p.serverKeepAlive);
    utils.set_defined_property(connack, "responseInformation", (_q = mqtt_js_connack.properties) === null || _q === void 0 ? void 0 : _q.responseInformation);
    utils.set_defined_property(connack, "serverReference", (_r = mqtt_js_connack.properties) === null || _r === void 0 ? void 0 : _r.serverReference);
    return connack;
}
exports.transform_mqtt_js_connack_to_crt_connack = transform_mqtt_js_connack_to_crt_connack;
/** @internal */
function create_negotiated_settings(config, connack) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
    if (config == null || config == undefined) {
        throw new error_1.CrtError("create_negotiated_settings: config not defined");
    }
    if (connack == null || connack == undefined) {
        throw new error_1.CrtError("create_negotiated_settings: connack not defined");
    }
    return {
        maximumQos: Math.min((_a = connack.maximumQos) !== null && _a !== void 0 ? _a : mqtt5.QoS.ExactlyOnce, mqtt5.QoS.AtLeastOnce),
        sessionExpiryInterval: (_d = (_b = connack.sessionExpiryInterval) !== null && _b !== void 0 ? _b : (_c = config.connectProperties) === null || _c === void 0 ? void 0 : _c.sessionExpiryIntervalSeconds) !== null && _d !== void 0 ? _d : 0,
        receiveMaximumFromServer: (_e = connack.receiveMaximum) !== null && _e !== void 0 ? _e : exports.DEFAULT_RECEIVE_MAXIMUM,
        maximumPacketSizeToServer: (_f = connack.maximumPacketSize) !== null && _f !== void 0 ? _f : exports.MAXIMUM_PACKET_SIZE,
        topicAliasMaximumToServer: Math.min((_h = (_g = config.topicAliasingOptions) === null || _g === void 0 ? void 0 : _g.outboundCacheMaxSize) !== null && _h !== void 0 ? _h : 0, (_j = connack.topicAliasMaximum) !== null && _j !== void 0 ? _j : 0),
        topicAliasMaximumToClient: (_l = (_k = config.topicAliasingOptions) === null || _k === void 0 ? void 0 : _k.inboundCacheMaxSize) !== null && _l !== void 0 ? _l : 0,
        serverKeepAlive: (_p = (_m = connack.serverKeepAlive) !== null && _m !== void 0 ? _m : (_o = config.connectProperties) === null || _o === void 0 ? void 0 : _o.keepAliveIntervalSeconds) !== null && _p !== void 0 ? _p : mqtt_shared.DEFAULT_KEEP_ALIVE,
        retainAvailable: (_q = connack.retainAvailable) !== null && _q !== void 0 ? _q : true,
        wildcardSubscriptionsAvailable: (_r = connack.wildcardSubscriptionsAvailable) !== null && _r !== void 0 ? _r : true,
        subscriptionIdentifiersAvailable: (_s = connack.subscriptionIdentifiersAvailable) !== null && _s !== void 0 ? _s : true,
        sharedSubscriptionsAvailable: (_t = connack.sharedSubscriptionsAvailable) !== null && _t !== void 0 ? _t : true,
        rejoinedSession: connack.sessionPresent,
        clientId: (_w = (_u = connack.assignedClientIdentifier) !== null && _u !== void 0 ? _u : (_v = config.connectProperties) === null || _v === void 0 ? void 0 : _v.clientId) !== null && _w !== void 0 ? _w : ""
    };
}
exports.create_negotiated_settings = create_negotiated_settings;
/** @internal */
function create_mqtt_js_will_from_crt_config(connectProperties) {
    var _a, _b;
    if (!connectProperties || !connectProperties.will) {
        return undefined;
    }
    var crtWill = connectProperties.will;
    var hasWillProperties = false;
    var willProperties = {};
    hasWillProperties = utils.set_defined_property(willProperties, "willDelayInterval", connectProperties.willDelayIntervalSeconds) || hasWillProperties;
    if (crtWill.payloadFormat !== undefined) {
        hasWillProperties = utils.set_defined_property(willProperties, "payloadFormatIndicator", crtWill.payloadFormat == mqtt5.PayloadFormatIndicator.Utf8) || hasWillProperties;
    }
    hasWillProperties = utils.set_defined_property(willProperties, "messageExpiryInterval", crtWill.messageExpiryIntervalSeconds) || hasWillProperties;
    hasWillProperties = utils.set_defined_property(willProperties, "contentType", crtWill.contentType) || hasWillProperties;
    hasWillProperties = utils.set_defined_property(willProperties, "responseTopic", crtWill.responseTopic) || hasWillProperties;
    hasWillProperties = utils.set_defined_property(willProperties, "correlationData", crtWill.correlationData) || hasWillProperties;
    hasWillProperties = utils.set_defined_property(willProperties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties(crtWill.userProperties)) || hasWillProperties;
    var will = {
        topic: crtWill.topicName,
        payload: (_a = crtWill.payload) !== null && _a !== void 0 ? _a : mqtt_shared.normalize_payload_to_buffer(""),
        qos: crtWill.qos,
        retain: (_b = crtWill.retain) !== null && _b !== void 0 ? _b : false
    };
    if (hasWillProperties) {
        will["properties"] = willProperties;
    }
    return will;
}
/** @internal */
function getOrderedReconnectDelayBounds(configMin, configMax) {
    var minDelay = Math.max(1, configMin !== null && configMin !== void 0 ? configMin : exports.DEFAULT_MIN_RECONNECT_DELAY_MS);
    var maxDelay = Math.max(1, configMax !== null && configMax !== void 0 ? configMax : exports.DEFAULT_MAX_RECONNECT_DELAY_MS);
    if (minDelay > maxDelay) {
        return [maxDelay, minDelay];
    }
    else {
        return [minDelay, maxDelay];
    }
}
exports.getOrderedReconnectDelayBounds = getOrderedReconnectDelayBounds;
/** @internal */
function should_mqtt_js_use_clean_start(session_behavior) {
    return session_behavior !== mqtt5.ClientSessionBehavior.RejoinPostSuccess && session_behavior !== mqtt5.ClientSessionBehavior.RejoinAlways;
}
/** @internal */
function compute_mqtt_js_reconnect_delay_from_crt_max_delay(maxReconnectDelayMs) {
    /*
     * This is an attempt to guarantee that the mqtt-js will never try to reconnect on its own and instead always
     * be controlled by our reconnection scheduler logic.
     */
    return maxReconnectDelayMs * 2 + 60000;
}
exports.compute_mqtt_js_reconnect_delay_from_crt_max_delay = compute_mqtt_js_reconnect_delay_from_crt_max_delay;
function validate_required_uint16(propertyName, value) {
    if (value < 0 || value > 65535) {
        throw new error_1.CrtError("Invalid value for property ".concat(propertyName, ": ") + value);
    }
}
function validate_optional_uint16(propertyName, value) {
    if (value !== undefined) {
        validate_required_uint16(propertyName, value);
    }
}
function validate_required_uint32(propertyName, value) {
    if (value < 0 || value >= 4294967296) {
        throw new error_1.CrtError("Invalid value for property ".concat(propertyName, ": ") + value);
    }
}
function validate_optional_uint32(propertyName, value) {
    if (value !== undefined) {
        validate_required_uint32(propertyName, value);
    }
}
function validate_required_nonnegative_uint32(propertyName, value) {
    if (value <= 0 || value >= 4294967296) {
        throw new error_1.CrtError("Invalid value for property ".concat(propertyName, ": ") + value);
    }
}
function validate_optional_nonnegative_uint32(propertyName, value) {
    if (value !== undefined) {
        validate_required_nonnegative_uint32(propertyName, value);
    }
}
function validate_mqtt5_client_config(crtConfig) {
    var _a, _b, _c, _d, _e, _f;
    if (crtConfig == null || crtConfig == undefined) {
        throw new error_1.CrtError("validate_mqtt5_client_config: crtConfig not defined");
    }
    validate_required_uint16("keepAliveIntervalSeconds", (_b = (_a = crtConfig.connectProperties) === null || _a === void 0 ? void 0 : _a.keepAliveIntervalSeconds) !== null && _b !== void 0 ? _b : 0);
    validate_optional_uint32("sessionExpiryIntervalSeconds", (_c = crtConfig.connectProperties) === null || _c === void 0 ? void 0 : _c.sessionExpiryIntervalSeconds);
    validate_optional_uint16("receiveMaximum", (_d = crtConfig.connectProperties) === null || _d === void 0 ? void 0 : _d.receiveMaximum);
    validate_optional_nonnegative_uint32("maximumPacketSizeBytes", (_e = crtConfig.connectProperties) === null || _e === void 0 ? void 0 : _e.maximumPacketSizeBytes);
    validate_optional_uint32("willDelayIntervalSeconds", (_f = crtConfig.connectProperties) === null || _f === void 0 ? void 0 : _f.willDelayIntervalSeconds);
}
/** @internal */
function create_mqtt_js_client_config_from_crt_client_config(crtConfig) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
    validate_mqtt5_client_config(crtConfig);
    var _q = __read(getOrderedReconnectDelayBounds(crtConfig.minReconnectDelayMs, crtConfig.maxReconnectDelayMs), 2), _ = _q[0], maxDelay = _q[1];
    maxDelay = compute_mqtt_js_reconnect_delay_from_crt_max_delay(maxDelay);
    var mqttJsClientConfig = {
        protocolVersion: 5,
        keepalive: (_b = (_a = crtConfig.connectProperties) === null || _a === void 0 ? void 0 : _a.keepAliveIntervalSeconds) !== null && _b !== void 0 ? _b : mqtt_shared.DEFAULT_KEEP_ALIVE,
        connectTimeout: (_c = crtConfig.connectTimeoutMs) !== null && _c !== void 0 ? _c : exports.DEFAULT_CONNECT_TIMEOUT_MS,
        clean: should_mqtt_js_use_clean_start(crtConfig.sessionBehavior),
        reconnectPeriod: maxDelay,
        // @ts-ignore
        autoUseTopicAlias: false,
        // @ts-ignore
        autoAssignTopicAlias: false,
        queueQoSZero: false,
        transformWsUrl: undefined,
        resubscribe: false
    };
    var topic_aliasing_options = crtConfig.topicAliasingOptions;
    if (topic_aliasing_options) {
        switch ((_d = topic_aliasing_options.outboundBehavior) !== null && _d !== void 0 ? _d : mqtt5.OutboundTopicAliasBehaviorType.Default) {
            case mqtt5.OutboundTopicAliasBehaviorType.LRU:
                // @ts-ignore
                mqttJsClientConfig.autoUseTopicAlias = true;
                // @ts-ignore
                mqttJsClientConfig.autoAssignTopicAlias = true;
                break;
            case mqtt5.OutboundTopicAliasBehaviorType.Manual:
                // @ts-ignore
                mqttJsClientConfig.autoUseTopicAlias = true;
                break;
            default:
                break;
        }
    }
    /*
     * If you leave clientId undefined, mqtt-js will make up some weird thing for you, but the intent is that it
     * should pass the empty client id so that the server assigns you one.
     */
    utils.set_defined_property(mqttJsClientConfig, "clientId", (_f = (_e = crtConfig.connectProperties) === null || _e === void 0 ? void 0 : _e.clientId) !== null && _f !== void 0 ? _f : "");
    utils.set_defined_property(mqttJsClientConfig, "username", (_g = crtConfig.connectProperties) === null || _g === void 0 ? void 0 : _g.username);
    utils.set_defined_property(mqttJsClientConfig, "password", (_h = crtConfig.connectProperties) === null || _h === void 0 ? void 0 : _h.password);
    utils.set_defined_property(mqttJsClientConfig, "will", create_mqtt_js_will_from_crt_config(crtConfig.connectProperties));
    var hasProperties = false;
    var properties = {};
    hasProperties = utils.set_defined_property(properties, "sessionExpiryInterval", (_j = crtConfig.connectProperties) === null || _j === void 0 ? void 0 : _j.sessionExpiryIntervalSeconds) || hasProperties;
    hasProperties = utils.set_defined_property(properties, "receiveMaximum", (_k = crtConfig.connectProperties) === null || _k === void 0 ? void 0 : _k.receiveMaximum) || hasProperties;
    hasProperties = utils.set_defined_property(properties, "maximumPacketSize", (_l = crtConfig.connectProperties) === null || _l === void 0 ? void 0 : _l.maximumPacketSizeBytes) || hasProperties;
    hasProperties = utils.set_defined_property(properties, "requestResponseInformation", (_m = crtConfig.connectProperties) === null || _m === void 0 ? void 0 : _m.requestResponseInformation) || hasProperties;
    hasProperties = utils.set_defined_property(properties, "requestProblemInformation", (_o = crtConfig.connectProperties) === null || _o === void 0 ? void 0 : _o.requestProblemInformation) || hasProperties;
    hasProperties = utils.set_defined_property(properties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties((_p = crtConfig.connectProperties) === null || _p === void 0 ? void 0 : _p.userProperties)) || hasProperties;
    if (hasProperties) {
        mqttJsClientConfig["properties"] = properties;
    }
    return mqttJsClientConfig;
}
exports.create_mqtt_js_client_config_from_crt_client_config = create_mqtt_js_client_config_from_crt_client_config;
/** @internal */
function transform_crt_user_properties_to_mqtt_js_user_properties(userProperties) {
    var e_1, _a;
    if (!userProperties) {
        return undefined;
    }
    /*
     * More restricted version of mqtt.UserProperties so that we can have type-checking but don't need to handle
     * the non-array case.
     */
    var mqttJsProperties = {};
    try {
        for (var userProperties_1 = __values(userProperties), userProperties_1_1 = userProperties_1.next(); !userProperties_1_1.done; userProperties_1_1 = userProperties_1.next()) {
            var property = userProperties_1_1.value;
            var key = property.name;
            if (!(key in mqttJsProperties)) {
                mqttJsProperties[key] = [];
            }
            mqttJsProperties[key].push(property.value);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (userProperties_1_1 && !userProperties_1_1.done && (_a = userProperties_1.return)) _a.call(userProperties_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return mqttJsProperties;
}
exports.transform_crt_user_properties_to_mqtt_js_user_properties = transform_crt_user_properties_to_mqtt_js_user_properties;
/** @internal */
function transform_mqtt_js_user_properties_to_crt_user_properties(userProperties) {
    var e_2, _a, e_3, _b;
    if (!userProperties) {
        return undefined;
    }
    var crtProperties = undefined;
    try {
        for (var _c = __values(Object.entries(userProperties)), _d = _c.next(); !_d.done; _d = _c.next()) {
            var _e = __read(_d.value, 2), propName = _e[0], propValue = _e[1];
            var values = (typeof propValue === 'string') ? [propValue] : propValue;
            try {
                for (var values_1 = (e_3 = void 0, __values(values)), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                    var valueIter = values_1_1.value;
                    var propertyEntry = { name: propName, value: valueIter };
                    if (!crtProperties) {
                        crtProperties = [propertyEntry];
                    }
                    else {
                        crtProperties.push(propertyEntry);
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (values_1_1 && !values_1_1.done && (_b = values_1.return)) _b.call(values_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return crtProperties;
}
exports.transform_mqtt_js_user_properties_to_crt_user_properties = transform_mqtt_js_user_properties_to_crt_user_properties;
function validate_crt_disconnect(disconnect) {
    if (disconnect == null || disconnect == undefined) {
        throw new error_1.CrtError("validate_crt_disconnect: disconnect not defined");
    }
    validate_optional_uint32("sessionExpiryIntervalSeconds", disconnect.sessionExpiryIntervalSeconds);
}
/** @internal */
function transform_crt_disconnect_to_mqtt_js_disconnect(disconnect) {
    validate_crt_disconnect(disconnect);
    var properties = {};
    var propertiesValid = false;
    propertiesValid = utils.set_defined_property(properties, "sessionExpiryInterval", disconnect.sessionExpiryIntervalSeconds) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "reasonString", disconnect.reasonString) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties(disconnect.userProperties)) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "serverReference", disconnect.serverReference) || propertiesValid;
    var mqttJsDisconnect = {
        cmd: 'disconnect',
        reasonCode: disconnect.reasonCode
    };
    if (propertiesValid) {
        mqttJsDisconnect["properties"] = properties;
    }
    return mqttJsDisconnect;
}
exports.transform_crt_disconnect_to_mqtt_js_disconnect = transform_crt_disconnect_to_mqtt_js_disconnect;
/** @internal **/
function transform_mqtt_js_disconnect_to_crt_disconnect(disconnect) {
    var _a, _b, _c, _d, _e;
    if (disconnect == null || disconnect == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_disconnect_to_crt_disconnect: disconnect not defined");
    }
    var crtDisconnect = {
        type: mqtt5.PacketType.Disconnect,
        reasonCode: (_a = disconnect.reasonCode) !== null && _a !== void 0 ? _a : mqtt5.DisconnectReasonCode.NormalDisconnection
    };
    utils.set_defined_property(crtDisconnect, "sessionExpiryIntervalSeconds", (_b = disconnect.properties) === null || _b === void 0 ? void 0 : _b.sessionExpiryInterval);
    utils.set_defined_property(crtDisconnect, "reasonString", (_c = disconnect.properties) === null || _c === void 0 ? void 0 : _c.reasonString);
    utils.set_defined_property(crtDisconnect, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_d = disconnect.properties) === null || _d === void 0 ? void 0 : _d.userProperties));
    utils.set_defined_property(crtDisconnect, "serverReference", (_e = disconnect.properties) === null || _e === void 0 ? void 0 : _e.serverReference);
    return crtDisconnect;
}
exports.transform_mqtt_js_disconnect_to_crt_disconnect = transform_mqtt_js_disconnect_to_crt_disconnect;
function validate_crt_subscribe(subscribe) {
    if (subscribe == null || subscribe == undefined) {
        throw new error_1.CrtError("validate_crt_subscribe: subscribe not defined");
    }
    validate_optional_uint32("subscriptionIdentifier", subscribe.subscriptionIdentifier);
}
/** @internal **/
function transform_crt_subscribe_to_mqtt_js_subscription_map(subscribe) {
    var e_4, _a;
    var _b, _c, _d;
    validate_crt_subscribe(subscribe);
    var subscriptionMap = {};
    try {
        for (var _e = __values(subscribe.subscriptions), _f = _e.next(); !_f.done; _f = _e.next()) {
            var subscription = _f.value;
            var mqttJsSub = {
                qos: subscription.qos,
                nl: (_b = subscription.noLocal) !== null && _b !== void 0 ? _b : false,
                rap: (_c = subscription.retainAsPublished) !== null && _c !== void 0 ? _c : false,
                rh: (_d = subscription.retainHandlingType) !== null && _d !== void 0 ? _d : mqtt5.RetainHandlingType.SendOnSubscribe
            };
            subscriptionMap[subscription.topicFilter] = mqttJsSub;
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return subscriptionMap;
}
exports.transform_crt_subscribe_to_mqtt_js_subscription_map = transform_crt_subscribe_to_mqtt_js_subscription_map;
/** @internal **/
function transform_crt_subscribe_to_mqtt_js_subscribe_options(subscribe) {
    var properties = {};
    var propertiesValid = false;
    if (subscribe == null || subscribe == undefined) {
        throw new error_1.CrtError("transform_crt_subscribe_to_mqtt_js_subscribe_options: subscribe not defined");
    }
    propertiesValid = utils.set_defined_property(properties, "subscriptionIdentifier", subscribe.subscriptionIdentifier) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties(subscribe.userProperties)) || propertiesValid;
    var options = {
        qos: 0
    };
    if (propertiesValid) {
        options["properties"] = properties;
    }
    return options;
}
exports.transform_crt_subscribe_to_mqtt_js_subscribe_options = transform_crt_subscribe_to_mqtt_js_subscribe_options;
/** @internal **/
function transform_mqtt_js_suback_to_crt_suback(mqttJsSuback) {
    var _a, _b;
    if (!mqttJsSuback) {
        throw new error_1.CrtError("transform_mqtt_js_suback_to_crt_suback: mqttJsSuback not defined");
    }
    var crtSuback = {
        type: mqtt5.PacketType.Suback,
        reasonCodes: mqttJsSuback.granted.map(function (value, index, array) { return value; }),
    };
    if (mqttJsSuback.properties) {
        utils.set_defined_property(crtSuback, "reasonString", (_a = mqttJsSuback.properties) === null || _a === void 0 ? void 0 : _a.reasonString);
        utils.set_defined_property(crtSuback, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_b = mqttJsSuback.properties) === null || _b === void 0 ? void 0 : _b.userProperties));
    }
    return crtSuback;
}
exports.transform_mqtt_js_suback_to_crt_suback = transform_mqtt_js_suback_to_crt_suback;
/** @internal **/
function transform_mqtt_js_subscription_grants_to_crt_suback(subscriptionsGranted) {
    if (subscriptionsGranted == null || subscriptionsGranted == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_subscription_grants_to_crt_suback: subscriptionsGranted not defined");
    }
    var crtSuback = {
        type: mqtt5.PacketType.Suback,
        reasonCodes: subscriptionsGranted.map(function (subscription, index, array) { return subscription.qos; })
    };
    /*
     * TODO: mqtt-js does not expose the suback packet to subscribe's completion callback, so we cannot extract
     * reasonString and userProperties atm.
     *
     * Revisit if this changes.
     */
    return crtSuback;
}
exports.transform_mqtt_js_subscription_grants_to_crt_suback = transform_mqtt_js_subscription_grants_to_crt_suback;
function validate_crt_publish(publish) {
    if (publish == null || publish == undefined) {
        throw new error_1.CrtError("validate_crt_publish: publish not defined");
    }
    validate_optional_uint32("messageExpiryIntervalSeconds", publish.messageExpiryIntervalSeconds);
}
/** @internal */
function transform_crt_publish_to_mqtt_js_publish_options(publish) {
    var _a;
    validate_crt_publish(publish);
    var properties = {};
    var propertiesValid = false;
    if (publish.payloadFormat !== undefined) {
        propertiesValid = utils.set_defined_property(properties, "payloadFormatIndicator", publish.payloadFormat == mqtt5.PayloadFormatIndicator.Utf8) || propertiesValid;
    }
    propertiesValid = utils.set_defined_property(properties, "messageExpiryInterval", publish.messageExpiryIntervalSeconds) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "responseTopic", publish.responseTopic) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "correlationData", publish.correlationData) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties(publish.userProperties)) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "contentType", publish.contentType) || propertiesValid;
    propertiesValid = utils.set_defined_property(properties, "topicAlias", publish.topicAlias) || propertiesValid;
    var mqttJsPublish = {
        qos: publish.qos,
        retain: (_a = publish.retain) !== null && _a !== void 0 ? _a : false,
    };
    if (propertiesValid) {
        mqttJsPublish["properties"] = properties;
    }
    return mqttJsPublish;
}
exports.transform_crt_publish_to_mqtt_js_publish_options = transform_crt_publish_to_mqtt_js_publish_options;
/** @internal **/
function transform_mqtt_js_publish_to_crt_publish(publish) {
    var _a, _b, _c, _d, _e, _f;
    if (publish == null || publish == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_publish_to_crt_publish: publish not defined");
    }
    var crtPublish = {
        type: mqtt5.PacketType.Publish,
        qos: publish.qos,
        retain: publish.retain,
        topicName: publish.topic,
        payload: publish.payload
    };
    if (publish.properties) {
        if (publish.properties.payloadFormatIndicator !== undefined) {
            utils.set_defined_property(crtPublish, "payloadFormat", publish.properties.payloadFormatIndicator ? mqtt5.PayloadFormatIndicator.Utf8 : mqtt5.PayloadFormatIndicator.Bytes);
        }
        utils.set_defined_property(crtPublish, "messageExpiryIntervalSeconds", (_a = publish.properties) === null || _a === void 0 ? void 0 : _a.messageExpiryInterval);
        utils.set_defined_property(crtPublish, "responseTopic", (_b = publish.properties) === null || _b === void 0 ? void 0 : _b.responseTopic);
        utils.set_defined_property(crtPublish, "correlationData", (_c = publish.properties) === null || _c === void 0 ? void 0 : _c.correlationData);
        utils.set_defined_property(crtPublish, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_d = publish.properties) === null || _d === void 0 ? void 0 : _d.userProperties));
        utils.set_defined_property(crtPublish, "contentType", (_e = publish.properties) === null || _e === void 0 ? void 0 : _e.contentType);
        var subIds = (_f = publish.properties) === null || _f === void 0 ? void 0 : _f.subscriptionIdentifier;
        var subIdsType = typeof subIds;
        if (subIds) {
            if (subIdsType == 'number') {
                crtPublish["subscriptionIdentifiers"] = [subIds];
            }
            else if (Array.isArray(subIds)) {
                crtPublish["subscriptionIdentifiers"] = subIds;
            }
        }
    }
    return crtPublish;
}
exports.transform_mqtt_js_publish_to_crt_publish = transform_mqtt_js_publish_to_crt_publish;
/** @internal **/
function transform_mqtt_js_puback_to_crt_puback(puback) {
    var _a, _b, _c;
    if (puback == null || puback == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_puback_to_crt_puback: puback not defined");
    }
    var crtPuback = {
        type: mqtt5.PacketType.Puback,
        reasonCode: (_a = puback.reasonCode) !== null && _a !== void 0 ? _a : mqtt5.PubackReasonCode.Success,
    };
    if (puback.properties) {
        utils.set_defined_property(crtPuback, "reasonString", (_b = puback.properties) === null || _b === void 0 ? void 0 : _b.reasonString);
        utils.set_defined_property(crtPuback, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_c = puback.properties) === null || _c === void 0 ? void 0 : _c.userProperties));
    }
    return crtPuback;
}
exports.transform_mqtt_js_puback_to_crt_puback = transform_mqtt_js_puback_to_crt_puback;
/** @internal **/
function transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options(unsubscribe) {
    if (unsubscribe == null || unsubscribe == undefined) {
        throw new error_1.CrtError("transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options: unsubscribe not defined");
    }
    var properties = {};
    var propertiesValid = false;
    propertiesValid = utils.set_defined_property(properties, "userProperties", transform_crt_user_properties_to_mqtt_js_user_properties(unsubscribe.userProperties));
    var options = {};
    if (propertiesValid) {
        options["properties"] = properties;
    }
    return options;
}
exports.transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options = transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options;
/** @internal **/
function transform_mqtt_js_unsuback_to_crt_unsuback(packet) {
    var _a, _b;
    if (packet == null || packet == undefined) {
        throw new error_1.CrtError("transform_mqtt_js_unsuback_to_crt_unsuback: packet not defined");
    }
    var reasonCodes = packet.reasonCode;
    var codes;
    if (Array.isArray(reasonCodes)) {
        codes = reasonCodes;
    }
    else if (typeof reasonCodes == 'number') {
        codes = [reasonCodes];
    }
    else {
        codes = [];
    }
    var crtUnsuback = {
        type: mqtt5.PacketType.Unsuback,
        reasonCodes: codes
    };
    if (packet.properties) {
        utils.set_defined_property(crtUnsuback, "reasonString", (_a = packet.properties) === null || _a === void 0 ? void 0 : _a.reasonString);
        utils.set_defined_property(crtUnsuback, "userProperties", transform_mqtt_js_user_properties_to_crt_user_properties((_b = packet.properties) === null || _b === void 0 ? void 0 : _b.userProperties));
    }
    return crtUnsuback;
}
exports.transform_mqtt_js_unsuback_to_crt_unsuback = transform_mqtt_js_unsuback_to_crt_unsuback;
//# sourceMappingURL=mqtt5_utils.js.map