import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { CloudWatchLogsServiceException as __BaseException } from "./CloudWatchLogsServiceException";
export interface AssociateKmsKeyRequest {
  logGroupName: string | undefined;
  kmsKeyId: string | undefined;
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class OperationAbortedException extends __BaseException {
  readonly name: "OperationAbortedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OperationAbortedException, __BaseException>
  );
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export interface CancelExportTaskRequest {
  taskId: string | undefined;
}
export declare class InvalidOperationException extends __BaseException {
  readonly name: "InvalidOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOperationException, __BaseException>
  );
}
export interface CreateExportTaskRequest {
  taskName?: string;
  logGroupName: string | undefined;
  logStreamNamePrefix?: string;
  from: number | undefined;
  to: number | undefined;
  destination: string | undefined;
  destinationPrefix?: string;
}
export interface CreateExportTaskResponse {
  taskId?: string;
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class ResourceAlreadyExistsException extends __BaseException {
  readonly name: "ResourceAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceAlreadyExistsException, __BaseException>
  );
}
export interface CreateLogGroupRequest {
  logGroupName: string | undefined;
  kmsKeyId?: string;
  tags?: Record<string, string>;
}
export interface CreateLogStreamRequest {
  logGroupName: string | undefined;
  logStreamName: string | undefined;
}
export declare class DataAlreadyAcceptedException extends __BaseException {
  readonly name: "DataAlreadyAcceptedException";
  readonly $fault: "client";
  expectedSequenceToken?: string;
  constructor(
    opts: __ExceptionOptionType<DataAlreadyAcceptedException, __BaseException>
  );
}
export declare enum DataProtectionStatus {
  ACTIVATED = "ACTIVATED",
  ARCHIVED = "ARCHIVED",
  DELETED = "DELETED",
  DISABLED = "DISABLED",
}
export interface DeleteDataProtectionPolicyRequest {
  logGroupIdentifier: string | undefined;
}
export interface DeleteDestinationRequest {
  destinationName: string | undefined;
}
export interface DeleteLogGroupRequest {
  logGroupName: string | undefined;
}
export interface DeleteLogStreamRequest {
  logGroupName: string | undefined;
  logStreamName: string | undefined;
}
export interface DeleteMetricFilterRequest {
  logGroupName: string | undefined;
  filterName: string | undefined;
}
export interface DeleteQueryDefinitionRequest {
  queryDefinitionId: string | undefined;
}
export interface DeleteQueryDefinitionResponse {
  success?: boolean;
}
export interface DeleteResourcePolicyRequest {
  policyName?: string;
}
export interface DeleteRetentionPolicyRequest {
  logGroupName: string | undefined;
}
export interface DeleteSubscriptionFilterRequest {
  logGroupName: string | undefined;
  filterName: string | undefined;
}
export interface DescribeDestinationsRequest {
  DestinationNamePrefix?: string;
  nextToken?: string;
  limit?: number;
}
export interface Destination {
  destinationName?: string;
  targetArn?: string;
  roleArn?: string;
  accessPolicy?: string;
  arn?: string;
  creationTime?: number;
}
export interface DescribeDestinationsResponse {
  destinations?: Destination[];
  nextToken?: string;
}
export declare enum ExportTaskStatusCode {
  CANCELLED = "CANCELLED",
  COMPLETED = "COMPLETED",
  FAILED = "FAILED",
  PENDING = "PENDING",
  PENDING_CANCEL = "PENDING_CANCEL",
  RUNNING = "RUNNING",
}
export interface DescribeExportTasksRequest {
  taskId?: string;
  statusCode?: ExportTaskStatusCode | string;
  nextToken?: string;
  limit?: number;
}
export interface ExportTaskExecutionInfo {
  creationTime?: number;
  completionTime?: number;
}
export interface ExportTaskStatus {
  code?: ExportTaskStatusCode | string;
  message?: string;
}
export interface ExportTask {
  taskId?: string;
  taskName?: string;
  logGroupName?: string;
  from?: number;
  to?: number;
  destination?: string;
  destinationPrefix?: string;
  status?: ExportTaskStatus;
  executionInfo?: ExportTaskExecutionInfo;
}
export interface DescribeExportTasksResponse {
  exportTasks?: ExportTask[];
  nextToken?: string;
}
export interface DescribeLogGroupsRequest {
  accountIdentifiers?: string[];
  logGroupNamePrefix?: string;
  logGroupNamePattern?: string;
  nextToken?: string;
  limit?: number;
  includeLinkedAccounts?: boolean;
}
export interface LogGroup {
  logGroupName?: string;
  creationTime?: number;
  retentionInDays?: number;
  metricFilterCount?: number;
  arn?: string;
  storedBytes?: number;
  kmsKeyId?: string;
  dataProtectionStatus?: DataProtectionStatus | string;
}
export interface DescribeLogGroupsResponse {
  logGroups?: LogGroup[];
  nextToken?: string;
}
export declare enum OrderBy {
  LastEventTime = "LastEventTime",
  LogStreamName = "LogStreamName",
}
export interface DescribeLogStreamsRequest {
  logGroupName: string | undefined;
  logGroupIdentifier?: string;
  logStreamNamePrefix?: string;
  orderBy?: OrderBy | string;
  descending?: boolean;
  nextToken?: string;
  limit?: number;
}
export interface LogStream {
  logStreamName?: string;
  creationTime?: number;
  firstEventTimestamp?: number;
  lastEventTimestamp?: number;
  lastIngestionTime?: number;
  uploadSequenceToken?: string;
  arn?: string;
  storedBytes?: number;
}
export interface DescribeLogStreamsResponse {
  logStreams?: LogStream[];
  nextToken?: string;
}
export interface DescribeMetricFiltersRequest {
  logGroupName?: string;
  filterNamePrefix?: string;
  nextToken?: string;
  limit?: number;
  metricName?: string;
  metricNamespace?: string;
}
export declare enum StandardUnit {
  Bits = "Bits",
  BitsSecond = "Bits/Second",
  Bytes = "Bytes",
  BytesSecond = "Bytes/Second",
  Count = "Count",
  CountSecond = "Count/Second",
  Gigabits = "Gigabits",
  GigabitsSecond = "Gigabits/Second",
  Gigabytes = "Gigabytes",
  GigabytesSecond = "Gigabytes/Second",
  Kilobits = "Kilobits",
  KilobitsSecond = "Kilobits/Second",
  Kilobytes = "Kilobytes",
  KilobytesSecond = "Kilobytes/Second",
  Megabits = "Megabits",
  MegabitsSecond = "Megabits/Second",
  Megabytes = "Megabytes",
  MegabytesSecond = "Megabytes/Second",
  Microseconds = "Microseconds",
  Milliseconds = "Milliseconds",
  None = "None",
  Percent = "Percent",
  Seconds = "Seconds",
  Terabits = "Terabits",
  TerabitsSecond = "Terabits/Second",
  Terabytes = "Terabytes",
  TerabytesSecond = "Terabytes/Second",
}
export interface MetricTransformation {
  metricName: string | undefined;
  metricNamespace: string | undefined;
  metricValue: string | undefined;
  defaultValue?: number;
  dimensions?: Record<string, string>;
  unit?: StandardUnit | string;
}
export interface MetricFilter {
  filterName?: string;
  filterPattern?: string;
  metricTransformations?: MetricTransformation[];
  creationTime?: number;
  logGroupName?: string;
}
export interface DescribeMetricFiltersResponse {
  metricFilters?: MetricFilter[];
  nextToken?: string;
}
export declare enum QueryStatus {
  Cancelled = "Cancelled",
  Complete = "Complete",
  Failed = "Failed",
  Running = "Running",
  Scheduled = "Scheduled",
  Timeout = "Timeout",
  Unknown = "Unknown",
}
export interface DescribeQueriesRequest {
  logGroupName?: string;
  status?: QueryStatus | string;
  maxResults?: number;
  nextToken?: string;
}
export interface QueryInfo {
  queryId?: string;
  queryString?: string;
  status?: QueryStatus | string;
  createTime?: number;
  logGroupName?: string;
}
export interface DescribeQueriesResponse {
  queries?: QueryInfo[];
  nextToken?: string;
}
export interface DescribeQueryDefinitionsRequest {
  queryDefinitionNamePrefix?: string;
  maxResults?: number;
  nextToken?: string;
}
export interface QueryDefinition {
  queryDefinitionId?: string;
  name?: string;
  queryString?: string;
  lastModified?: number;
  logGroupNames?: string[];
}
export interface DescribeQueryDefinitionsResponse {
  queryDefinitions?: QueryDefinition[];
  nextToken?: string;
}
export interface DescribeResourcePoliciesRequest {
  nextToken?: string;
  limit?: number;
}
export interface ResourcePolicy {
  policyName?: string;
  policyDocument?: string;
  lastUpdatedTime?: number;
}
export interface DescribeResourcePoliciesResponse {
  resourcePolicies?: ResourcePolicy[];
  nextToken?: string;
}
export interface DescribeSubscriptionFiltersRequest {
  logGroupName: string | undefined;
  filterNamePrefix?: string;
  nextToken?: string;
  limit?: number;
}
export declare enum Distribution {
  ByLogStream = "ByLogStream",
  Random = "Random",
}
export interface SubscriptionFilter {
  filterName?: string;
  logGroupName?: string;
  filterPattern?: string;
  destinationArn?: string;
  roleArn?: string;
  distribution?: Distribution | string;
  creationTime?: number;
}
export interface DescribeSubscriptionFiltersResponse {
  subscriptionFilters?: SubscriptionFilter[];
  nextToken?: string;
}
export interface DisassociateKmsKeyRequest {
  logGroupName: string | undefined;
}
export interface FilteredLogEvent {
  logStreamName?: string;
  timestamp?: number;
  message?: string;
  ingestionTime?: number;
  eventId?: string;
}
export interface FilterLogEventsRequest {
  logGroupName: string | undefined;
  logGroupIdentifier?: string;
  logStreamNames?: string[];
  logStreamNamePrefix?: string;
  startTime?: number;
  endTime?: number;
  filterPattern?: string;
  nextToken?: string;
  limit?: number;
  interleaved?: boolean;
  unmask?: boolean;
}
export interface SearchedLogStream {
  logStreamName?: string;
  searchedCompletely?: boolean;
}
export interface FilterLogEventsResponse {
  events?: FilteredLogEvent[];
  searchedLogStreams?: SearchedLogStream[];
  nextToken?: string;
}
export interface GetDataProtectionPolicyRequest {
  logGroupIdentifier: string | undefined;
}
export interface GetDataProtectionPolicyResponse {
  logGroupIdentifier?: string;
  policyDocument?: string;
  lastUpdatedTime?: number;
}
export interface GetLogEventsRequest {
  logGroupName: string | undefined;
  logGroupIdentifier?: string;
  logStreamName: string | undefined;
  startTime?: number;
  endTime?: number;
  nextToken?: string;
  limit?: number;
  startFromHead?: boolean;
  unmask?: boolean;
}
export interface OutputLogEvent {
  timestamp?: number;
  message?: string;
  ingestionTime?: number;
}
export interface GetLogEventsResponse {
  events?: OutputLogEvent[];
  nextForwardToken?: string;
  nextBackwardToken?: string;
}
export interface GetLogGroupFieldsRequest {
  logGroupName: string | undefined;
  time?: number;
  logGroupIdentifier?: string;
}
export interface LogGroupField {
  name?: string;
  percent?: number;
}
export interface GetLogGroupFieldsResponse {
  logGroupFields?: LogGroupField[];
}
export interface GetLogRecordRequest {
  logRecordPointer: string | undefined;
  unmask?: boolean;
}
export interface GetLogRecordResponse {
  logRecord?: Record<string, string>;
}
export interface GetQueryResultsRequest {
  queryId: string | undefined;
}
export interface ResultField {
  field?: string;
  value?: string;
}
export interface QueryStatistics {
  recordsMatched?: number;
  recordsScanned?: number;
  bytesScanned?: number;
}
export interface GetQueryResultsResponse {
  results?: ResultField[][];
  statistics?: QueryStatistics;
  status?: QueryStatus | string;
}
export interface InputLogEvent {
  timestamp: number | undefined;
  message: string | undefined;
}
export declare class InvalidSequenceTokenException extends __BaseException {
  readonly name: "InvalidSequenceTokenException";
  readonly $fault: "client";
  expectedSequenceToken?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidSequenceTokenException, __BaseException>
  );
}
export interface ListTagsForResourceRequest {
  resourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  tags?: Record<string, string>;
}
export interface ListTagsLogGroupRequest {
  logGroupName: string | undefined;
}
export interface ListTagsLogGroupResponse {
  tags?: Record<string, string>;
}
export interface PutDataProtectionPolicyRequest {
  logGroupIdentifier: string | undefined;
  policyDocument: string | undefined;
}
export interface PutDataProtectionPolicyResponse {
  logGroupIdentifier?: string;
  policyDocument?: string;
  lastUpdatedTime?: number;
}
export interface PutDestinationRequest {
  destinationName: string | undefined;
  targetArn: string | undefined;
  roleArn: string | undefined;
  tags?: Record<string, string>;
}
export interface PutDestinationResponse {
  destination?: Destination;
}
export interface PutDestinationPolicyRequest {
  destinationName: string | undefined;
  accessPolicy: string | undefined;
  forceUpdate?: boolean;
}
export interface PutLogEventsRequest {
  logGroupName: string | undefined;
  logStreamName: string | undefined;
  logEvents: InputLogEvent[] | undefined;
  sequenceToken?: string;
}
export interface RejectedLogEventsInfo {
  tooNewLogEventStartIndex?: number;
  tooOldLogEventEndIndex?: number;
  expiredLogEventEndIndex?: number;
}
export interface PutLogEventsResponse {
  nextSequenceToken?: string;
  rejectedLogEventsInfo?: RejectedLogEventsInfo;
}
export declare class UnrecognizedClientException extends __BaseException {
  readonly name: "UnrecognizedClientException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnrecognizedClientException, __BaseException>
  );
}
export interface PutMetricFilterRequest {
  logGroupName: string | undefined;
  filterName: string | undefined;
  filterPattern: string | undefined;
  metricTransformations: MetricTransformation[] | undefined;
}
export interface PutQueryDefinitionRequest {
  name: string | undefined;
  queryDefinitionId?: string;
  logGroupNames?: string[];
  queryString: string | undefined;
}
export interface PutQueryDefinitionResponse {
  queryDefinitionId?: string;
}
export interface PutResourcePolicyRequest {
  policyName?: string;
  policyDocument?: string;
}
export interface PutResourcePolicyResponse {
  resourcePolicy?: ResourcePolicy;
}
export interface PutRetentionPolicyRequest {
  logGroupName: string | undefined;
  retentionInDays: number | undefined;
}
export interface PutSubscriptionFilterRequest {
  logGroupName: string | undefined;
  filterName: string | undefined;
  filterPattern: string | undefined;
  destinationArn: string | undefined;
  roleArn?: string;
  distribution?: Distribution | string;
}
export interface QueryCompileErrorLocation {
  startCharOffset?: number;
  endCharOffset?: number;
}
export interface QueryCompileError {
  location?: QueryCompileErrorLocation;
  message?: string;
}
export declare class MalformedQueryException extends __BaseException {
  readonly name: "MalformedQueryException";
  readonly $fault: "client";
  queryCompileError?: QueryCompileError;
  constructor(
    opts: __ExceptionOptionType<MalformedQueryException, __BaseException>
  );
}
export interface StartQueryRequest {
  logGroupName?: string;
  logGroupNames?: string[];
  logGroupIdentifiers?: string[];
  startTime: number | undefined;
  endTime: number | undefined;
  queryString: string | undefined;
  limit?: number;
}
export interface StartQueryResponse {
  queryId?: string;
}
export interface StopQueryRequest {
  queryId: string | undefined;
}
export interface StopQueryResponse {
  success?: boolean;
}
export interface TagLogGroupRequest {
  logGroupName: string | undefined;
  tags: Record<string, string> | undefined;
}
export interface TagResourceRequest {
  resourceArn: string | undefined;
  tags: Record<string, string> | undefined;
}
export declare class TooManyTagsException extends __BaseException {
  readonly name: "TooManyTagsException";
  readonly $fault: "client";
  resourceName?: string;
  constructor(
    opts: __ExceptionOptionType<TooManyTagsException, __BaseException>
  );
}
export interface TestMetricFilterRequest {
  filterPattern: string | undefined;
  logEventMessages: string[] | undefined;
}
export interface MetricFilterMatchRecord {
  eventNumber?: number;
  eventMessage?: string;
  extractedValues?: Record<string, string>;
}
export interface TestMetricFilterResponse {
  matches?: MetricFilterMatchRecord[];
}
export interface UntagLogGroupRequest {
  logGroupName: string | undefined;
  tags: string[] | undefined;
}
export interface UntagResourceRequest {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export declare const AssociateKmsKeyRequestFilterSensitiveLog: (
  obj: AssociateKmsKeyRequest
) => any;
export declare const CancelExportTaskRequestFilterSensitiveLog: (
  obj: CancelExportTaskRequest
) => any;
export declare const CreateExportTaskRequestFilterSensitiveLog: (
  obj: CreateExportTaskRequest
) => any;
export declare const CreateExportTaskResponseFilterSensitiveLog: (
  obj: CreateExportTaskResponse
) => any;
export declare const CreateLogGroupRequestFilterSensitiveLog: (
  obj: CreateLogGroupRequest
) => any;
export declare const CreateLogStreamRequestFilterSensitiveLog: (
  obj: CreateLogStreamRequest
) => any;
export declare const DeleteDataProtectionPolicyRequestFilterSensitiveLog: (
  obj: DeleteDataProtectionPolicyRequest
) => any;
export declare const DeleteDestinationRequestFilterSensitiveLog: (
  obj: DeleteDestinationRequest
) => any;
export declare const DeleteLogGroupRequestFilterSensitiveLog: (
  obj: DeleteLogGroupRequest
) => any;
export declare const DeleteLogStreamRequestFilterSensitiveLog: (
  obj: DeleteLogStreamRequest
) => any;
export declare const DeleteMetricFilterRequestFilterSensitiveLog: (
  obj: DeleteMetricFilterRequest
) => any;
export declare const DeleteQueryDefinitionRequestFilterSensitiveLog: (
  obj: DeleteQueryDefinitionRequest
) => any;
export declare const DeleteQueryDefinitionResponseFilterSensitiveLog: (
  obj: DeleteQueryDefinitionResponse
) => any;
export declare const DeleteResourcePolicyRequestFilterSensitiveLog: (
  obj: DeleteResourcePolicyRequest
) => any;
export declare const DeleteRetentionPolicyRequestFilterSensitiveLog: (
  obj: DeleteRetentionPolicyRequest
) => any;
export declare const DeleteSubscriptionFilterRequestFilterSensitiveLog: (
  obj: DeleteSubscriptionFilterRequest
) => any;
export declare const DescribeDestinationsRequestFilterSensitiveLog: (
  obj: DescribeDestinationsRequest
) => any;
export declare const DestinationFilterSensitiveLog: (obj: Destination) => any;
export declare const DescribeDestinationsResponseFilterSensitiveLog: (
  obj: DescribeDestinationsResponse
) => any;
export declare const DescribeExportTasksRequestFilterSensitiveLog: (
  obj: DescribeExportTasksRequest
) => any;
export declare const ExportTaskExecutionInfoFilterSensitiveLog: (
  obj: ExportTaskExecutionInfo
) => any;
export declare const ExportTaskStatusFilterSensitiveLog: (
  obj: ExportTaskStatus
) => any;
export declare const ExportTaskFilterSensitiveLog: (obj: ExportTask) => any;
export declare const DescribeExportTasksResponseFilterSensitiveLog: (
  obj: DescribeExportTasksResponse
) => any;
export declare const DescribeLogGroupsRequestFilterSensitiveLog: (
  obj: DescribeLogGroupsRequest
) => any;
export declare const LogGroupFilterSensitiveLog: (obj: LogGroup) => any;
export declare const DescribeLogGroupsResponseFilterSensitiveLog: (
  obj: DescribeLogGroupsResponse
) => any;
export declare const DescribeLogStreamsRequestFilterSensitiveLog: (
  obj: DescribeLogStreamsRequest
) => any;
export declare const LogStreamFilterSensitiveLog: (obj: LogStream) => any;
export declare const DescribeLogStreamsResponseFilterSensitiveLog: (
  obj: DescribeLogStreamsResponse
) => any;
export declare const DescribeMetricFiltersRequestFilterSensitiveLog: (
  obj: DescribeMetricFiltersRequest
) => any;
export declare const MetricTransformationFilterSensitiveLog: (
  obj: MetricTransformation
) => any;
export declare const MetricFilterFilterSensitiveLog: (obj: MetricFilter) => any;
export declare const DescribeMetricFiltersResponseFilterSensitiveLog: (
  obj: DescribeMetricFiltersResponse
) => any;
export declare const DescribeQueriesRequestFilterSensitiveLog: (
  obj: DescribeQueriesRequest
) => any;
export declare const QueryInfoFilterSensitiveLog: (obj: QueryInfo) => any;
export declare const DescribeQueriesResponseFilterSensitiveLog: (
  obj: DescribeQueriesResponse
) => any;
export declare const DescribeQueryDefinitionsRequestFilterSensitiveLog: (
  obj: DescribeQueryDefinitionsRequest
) => any;
export declare const QueryDefinitionFilterSensitiveLog: (
  obj: QueryDefinition
) => any;
export declare const DescribeQueryDefinitionsResponseFilterSensitiveLog: (
  obj: DescribeQueryDefinitionsResponse
) => any;
export declare const DescribeResourcePoliciesRequestFilterSensitiveLog: (
  obj: DescribeResourcePoliciesRequest
) => any;
export declare const ResourcePolicyFilterSensitiveLog: (
  obj: ResourcePolicy
) => any;
export declare const DescribeResourcePoliciesResponseFilterSensitiveLog: (
  obj: DescribeResourcePoliciesResponse
) => any;
export declare const DescribeSubscriptionFiltersRequestFilterSensitiveLog: (
  obj: DescribeSubscriptionFiltersRequest
) => any;
export declare const SubscriptionFilterFilterSensitiveLog: (
  obj: SubscriptionFilter
) => any;
export declare const DescribeSubscriptionFiltersResponseFilterSensitiveLog: (
  obj: DescribeSubscriptionFiltersResponse
) => any;
export declare const DisassociateKmsKeyRequestFilterSensitiveLog: (
  obj: DisassociateKmsKeyRequest
) => any;
export declare const FilteredLogEventFilterSensitiveLog: (
  obj: FilteredLogEvent
) => any;
export declare const FilterLogEventsRequestFilterSensitiveLog: (
  obj: FilterLogEventsRequest
) => any;
export declare const SearchedLogStreamFilterSensitiveLog: (
  obj: SearchedLogStream
) => any;
export declare const FilterLogEventsResponseFilterSensitiveLog: (
  obj: FilterLogEventsResponse
) => any;
export declare const GetDataProtectionPolicyRequestFilterSensitiveLog: (
  obj: GetDataProtectionPolicyRequest
) => any;
export declare const GetDataProtectionPolicyResponseFilterSensitiveLog: (
  obj: GetDataProtectionPolicyResponse
) => any;
export declare const GetLogEventsRequestFilterSensitiveLog: (
  obj: GetLogEventsRequest
) => any;
export declare const OutputLogEventFilterSensitiveLog: (
  obj: OutputLogEvent
) => any;
export declare const GetLogEventsResponseFilterSensitiveLog: (
  obj: GetLogEventsResponse
) => any;
export declare const GetLogGroupFieldsRequestFilterSensitiveLog: (
  obj: GetLogGroupFieldsRequest
) => any;
export declare const LogGroupFieldFilterSensitiveLog: (
  obj: LogGroupField
) => any;
export declare const GetLogGroupFieldsResponseFilterSensitiveLog: (
  obj: GetLogGroupFieldsResponse
) => any;
export declare const GetLogRecordRequestFilterSensitiveLog: (
  obj: GetLogRecordRequest
) => any;
export declare const GetLogRecordResponseFilterSensitiveLog: (
  obj: GetLogRecordResponse
) => any;
export declare const GetQueryResultsRequestFilterSensitiveLog: (
  obj: GetQueryResultsRequest
) => any;
export declare const ResultFieldFilterSensitiveLog: (obj: ResultField) => any;
export declare const QueryStatisticsFilterSensitiveLog: (
  obj: QueryStatistics
) => any;
export declare const GetQueryResultsResponseFilterSensitiveLog: (
  obj: GetQueryResultsResponse
) => any;
export declare const InputLogEventFilterSensitiveLog: (
  obj: InputLogEvent
) => any;
export declare const ListTagsForResourceRequestFilterSensitiveLog: (
  obj: ListTagsForResourceRequest
) => any;
export declare const ListTagsForResourceResponseFilterSensitiveLog: (
  obj: ListTagsForResourceResponse
) => any;
export declare const ListTagsLogGroupRequestFilterSensitiveLog: (
  obj: ListTagsLogGroupRequest
) => any;
export declare const ListTagsLogGroupResponseFilterSensitiveLog: (
  obj: ListTagsLogGroupResponse
) => any;
export declare const PutDataProtectionPolicyRequestFilterSensitiveLog: (
  obj: PutDataProtectionPolicyRequest
) => any;
export declare const PutDataProtectionPolicyResponseFilterSensitiveLog: (
  obj: PutDataProtectionPolicyResponse
) => any;
export declare const PutDestinationRequestFilterSensitiveLog: (
  obj: PutDestinationRequest
) => any;
export declare const PutDestinationResponseFilterSensitiveLog: (
  obj: PutDestinationResponse
) => any;
export declare const PutDestinationPolicyRequestFilterSensitiveLog: (
  obj: PutDestinationPolicyRequest
) => any;
export declare const PutLogEventsRequestFilterSensitiveLog: (
  obj: PutLogEventsRequest
) => any;
export declare const RejectedLogEventsInfoFilterSensitiveLog: (
  obj: RejectedLogEventsInfo
) => any;
export declare const PutLogEventsResponseFilterSensitiveLog: (
  obj: PutLogEventsResponse
) => any;
export declare const PutMetricFilterRequestFilterSensitiveLog: (
  obj: PutMetricFilterRequest
) => any;
export declare const PutQueryDefinitionRequestFilterSensitiveLog: (
  obj: PutQueryDefinitionRequest
) => any;
export declare const PutQueryDefinitionResponseFilterSensitiveLog: (
  obj: PutQueryDefinitionResponse
) => any;
export declare const PutResourcePolicyRequestFilterSensitiveLog: (
  obj: PutResourcePolicyRequest
) => any;
export declare const PutResourcePolicyResponseFilterSensitiveLog: (
  obj: PutResourcePolicyResponse
) => any;
export declare const PutRetentionPolicyRequestFilterSensitiveLog: (
  obj: PutRetentionPolicyRequest
) => any;
export declare const PutSubscriptionFilterRequestFilterSensitiveLog: (
  obj: PutSubscriptionFilterRequest
) => any;
export declare const QueryCompileErrorLocationFilterSensitiveLog: (
  obj: QueryCompileErrorLocation
) => any;
export declare const QueryCompileErrorFilterSensitiveLog: (
  obj: QueryCompileError
) => any;
export declare const StartQueryRequestFilterSensitiveLog: (
  obj: StartQueryRequest
) => any;
export declare const StartQueryResponseFilterSensitiveLog: (
  obj: StartQueryResponse
) => any;
export declare const StopQueryRequestFilterSensitiveLog: (
  obj: StopQueryRequest
) => any;
export declare const StopQueryResponseFilterSensitiveLog: (
  obj: StopQueryResponse
) => any;
export declare const TagLogGroupRequestFilterSensitiveLog: (
  obj: TagLogGroupRequest
) => any;
export declare const TagResourceRequestFilterSensitiveLog: (
  obj: TagResourceRequest
) => any;
export declare const TestMetricFilterRequestFilterSensitiveLog: (
  obj: TestMetricFilterRequest
) => any;
export declare const MetricFilterMatchRecordFilterSensitiveLog: (
  obj: MetricFilterMatchRecord
) => any;
export declare const TestMetricFilterResponseFilterSensitiveLog: (
  obj: TestMetricFilterResponse
) => any;
export declare const UntagLogGroupRequestFilterSensitiveLog: (
  obj: UntagLogGroupRequest
) => any;
export declare const UntagResourceRequestFilterSensitiveLog: (
  obj: UntagResourceRequest
) => any;
