import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CloudWatchLogsClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudWatchLogsClient";
import { StartQueryRequest, StartQueryResponse } from "../models/models_0";
export interface StartQueryCommandInput extends StartQueryRequest {
}
export interface StartQueryCommandOutput extends StartQueryResponse, __MetadataBearer {
}
/**
 * <p>Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group
 *       and time range to query and the query string to use.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
 *          <p>Queries time out after 15 minutes of runtime. If your queries are timing out, reduce the
 *       time range being searched or partition your query into a number of queries.</p>
 *          <p>If you are using CloudWatch cross-account observability, you can use this operation in a
 *       monitoring account to start a query in a linked source account. For more information, see
 *         <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">CloudWatch
 *         cross-account observability</a>. For a cross-account <code>StartQuery</code> operation,
 *       the query definition must be defined in the monitoring account.</p>
 *          <p>You can have up to 20 concurrent CloudWatch Logs insights queries, including queries
 *       that have been added to dashboards. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudWatchLogsClient, StartQueryCommand } from "@aws-sdk/client-cloudwatch-logs"; // ES Modules import
 * // const { CloudWatchLogsClient, StartQueryCommand } = require("@aws-sdk/client-cloudwatch-logs"); // CommonJS import
 * const client = new CloudWatchLogsClient(config);
 * const command = new StartQueryCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link StartQueryCommandInput} for command's `input` shape.
 * @see {@link StartQueryCommandOutput} for command's `response` shape.
 * @see {@link CloudWatchLogsClientResolvedConfig | config} for CloudWatchLogsClient's `config` shape.
 *
 */
export declare class StartQueryCommand extends $Command<StartQueryCommandInput, StartQueryCommandOutput, CloudWatchLogsClientResolvedConfig> {
    readonly input: StartQueryCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: StartQueryCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudWatchLogsClientResolvedConfig, options?: __HttpHandlerOptions): Handler<StartQueryCommandInput, StartQueryCommandOutput>;
    private serialize;
    private deserialize;
}
