import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CloudWatchLogsClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudWatchLogsClient";
import { PutDataProtectionPolicyRequest, PutDataProtectionPolicyResponse } from "../models/models_0";
export interface PutDataProtectionPolicyCommandInput extends PutDataProtectionPolicyRequest {
}
export interface PutDataProtectionPolicyCommandOutput extends PutDataProtectionPolicyResponse, __MetadataBearer {
}
/**
 * <p>Creates a data protection policy for the specified log group. A data protection policy can help safeguard sensitive
 *       data that's ingested by the log group by auditing and masking the sensitive log data.</p>
 *          <important>
 *             <p>Sensitive data is detected and masked when it is ingested into the log group. When you set a
 *       data protection policy, log events ingested into the log group before that time are not masked.</p>
 *          </important>
 *          <p>By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
 *       A user who has the <code>logs:Unmask</code> permission can use a
 *       <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html">GetLogEvents</a> or
 *       <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html">FilterLogEvents</a>
 *       operation with the <code>unmask</code> parameter set to <code>true</code> to view the unmasked
 *       log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
 *       console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.</p>
 *          <p>For more information, including a list of types of data that can be audited and masked, see
 *       <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive log data with masking</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudWatchLogsClient, PutDataProtectionPolicyCommand } from "@aws-sdk/client-cloudwatch-logs"; // ES Modules import
 * // const { CloudWatchLogsClient, PutDataProtectionPolicyCommand } = require("@aws-sdk/client-cloudwatch-logs"); // CommonJS import
 * const client = new CloudWatchLogsClient(config);
 * const command = new PutDataProtectionPolicyCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link PutDataProtectionPolicyCommandInput} for command's `input` shape.
 * @see {@link PutDataProtectionPolicyCommandOutput} for command's `response` shape.
 * @see {@link CloudWatchLogsClientResolvedConfig | config} for CloudWatchLogsClient's `config` shape.
 *
 */
export declare class PutDataProtectionPolicyCommand extends $Command<PutDataProtectionPolicyCommandInput, PutDataProtectionPolicyCommandOutput, CloudWatchLogsClientResolvedConfig> {
    readonly input: PutDataProtectionPolicyCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: PutDataProtectionPolicyCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudWatchLogsClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PutDataProtectionPolicyCommandInput, PutDataProtectionPolicyCommandOutput>;
    private serialize;
    private deserialize;
}
