import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CloudWatchLogsClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudWatchLogsClient";
import { GetLogGroupFieldsRequest, GetLogGroupFieldsResponse } from "../models/models_0";
export interface GetLogGroupFieldsCommandInput extends GetLogGroupFieldsRequest {
}
export interface GetLogGroupFieldsCommandOutput extends GetLogGroupFieldsResponse, __MetadataBearer {
}
/**
 * <p>Returns a list of the fields that are included in log events in the specified log group.
 *       Includes the percentage of log events that contain each field. The search is limited to a time
 *       period that you specify.</p>
 *          <p>In the results, fields that start with <code>@</code> are fields generated by CloudWatch
 *       Logs. For example, <code>@timestamp</code> is the timestamp of each log event. For more
 *       information about the fields that are generated by CloudWatch logs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html">Supported
 *         Logs and Discovered Fields</a>.</p>
 *          <p>The response results are sorted by the frequency percentage, starting
 *     with the highest percentage.</p>
 *          <p>If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
 *       view data from the linked source accounts. For more information, see
 *       <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">CloudWatch cross-account observability</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudWatchLogsClient, GetLogGroupFieldsCommand } from "@aws-sdk/client-cloudwatch-logs"; // ES Modules import
 * // const { CloudWatchLogsClient, GetLogGroupFieldsCommand } = require("@aws-sdk/client-cloudwatch-logs"); // CommonJS import
 * const client = new CloudWatchLogsClient(config);
 * const command = new GetLogGroupFieldsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetLogGroupFieldsCommandInput} for command's `input` shape.
 * @see {@link GetLogGroupFieldsCommandOutput} for command's `response` shape.
 * @see {@link CloudWatchLogsClientResolvedConfig | config} for CloudWatchLogsClient's `config` shape.
 *
 */
export declare class GetLogGroupFieldsCommand extends $Command<GetLogGroupFieldsCommandInput, GetLogGroupFieldsCommandOutput, CloudWatchLogsClientResolvedConfig> {
    readonly input: GetLogGroupFieldsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetLogGroupFieldsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudWatchLogsClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetLogGroupFieldsCommandInput, GetLogGroupFieldsCommandOutput>;
    private serialize;
    private deserialize;
}
