import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CloudWatchLogsClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudWatchLogsClient";
import { DisassociateKmsKeyRequest } from "../models/models_0";
export interface DisassociateKmsKeyCommandInput extends DisassociateKmsKeyRequest {
}
export interface DisassociateKmsKeyCommandOutput extends __MetadataBearer {
}
/**
 * <p>Disassociates the associated KMS key from the specified log
 *       group.</p>
 *          <p>After the KMS key is disassociated from the log group, CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data
 *       remains encrypted, and CloudWatch Logs requires permissions for the KMS key
 *       whenever the encrypted data is requested.</p>
 *          <p>Note that it can take up to 5 minutes for this operation to take effect.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudWatchLogsClient, DisassociateKmsKeyCommand } from "@aws-sdk/client-cloudwatch-logs"; // ES Modules import
 * // const { CloudWatchLogsClient, DisassociateKmsKeyCommand } = require("@aws-sdk/client-cloudwatch-logs"); // CommonJS import
 * const client = new CloudWatchLogsClient(config);
 * const command = new DisassociateKmsKeyCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DisassociateKmsKeyCommandInput} for command's `input` shape.
 * @see {@link DisassociateKmsKeyCommandOutput} for command's `response` shape.
 * @see {@link CloudWatchLogsClientResolvedConfig | config} for CloudWatchLogsClient's `config` shape.
 *
 */
export declare class DisassociateKmsKeyCommand extends $Command<DisassociateKmsKeyCommandInput, DisassociateKmsKeyCommandOutput, CloudWatchLogsClientResolvedConfig> {
    readonly input: DisassociateKmsKeyCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DisassociateKmsKeyCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudWatchLogsClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DisassociateKmsKeyCommandInput, DisassociateKmsKeyCommandOutput>;
    private serialize;
    private deserialize;
}
