import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectLong as __expectLong, expectString as __expectString, limitedParseDouble as __limitedParseDouble, serializeFloat as __serializeFloat, throwDefaultError, } from "@aws-sdk/smithy-client";
import { CloudWatchLogsServiceException as __BaseException } from "../models/CloudWatchLogsServiceException";
import { DataAlreadyAcceptedException, InvalidOperationException, InvalidParameterException, InvalidSequenceTokenException, LimitExceededException, MalformedQueryException, OperationAbortedException, ResourceAlreadyExistsException, ResourceNotFoundException, ServiceUnavailableException, TooManyTagsException, UnrecognizedClientException, } from "../models/models_0";
export const serializeAws_json1_1AssociateKmsKeyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.AssociateKmsKey",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1AssociateKmsKeyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1CancelExportTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.CancelExportTask",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CancelExportTaskRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1CreateExportTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.CreateExportTask",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CreateExportTaskRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1CreateLogGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.CreateLogGroup",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CreateLogGroupRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1CreateLogStreamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.CreateLogStream",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CreateLogStreamRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteDataProtectionPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteDataProtectionPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteDataProtectionPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteDestinationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteDestination",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteDestinationRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteLogGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteLogGroup",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteLogGroupRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteLogStreamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteLogStream",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteLogStreamRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteMetricFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteMetricFilter",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteMetricFilterRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteQueryDefinitionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteQueryDefinition",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteQueryDefinitionRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteRetentionPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteRetentionPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteRetentionPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteSubscriptionFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DeleteSubscriptionFilter",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteSubscriptionFilterRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeDestinationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeDestinations",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeDestinationsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeExportTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeExportTasks",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeExportTasksRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeLogGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeLogGroups",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeLogGroupsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeLogStreamsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeLogStreams",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeLogStreamsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeMetricFiltersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeMetricFilters",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeMetricFiltersRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeQueriesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeQueries",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeQueriesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeQueryDefinitionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeQueryDefinitions",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeQueryDefinitionsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeResourcePoliciesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeResourcePolicies",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeResourcePoliciesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeSubscriptionFiltersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DescribeSubscriptionFilters",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeSubscriptionFiltersRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DisassociateKmsKeyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.DisassociateKmsKey",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DisassociateKmsKeyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1FilterLogEventsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.FilterLogEvents",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1FilterLogEventsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetDataProtectionPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.GetDataProtectionPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetDataProtectionPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetLogEventsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.GetLogEvents",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetLogEventsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetLogGroupFieldsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.GetLogGroupFields",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetLogGroupFieldsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetLogRecordCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.GetLogRecord",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetLogRecordRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetQueryResultsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.GetQueryResults",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetQueryResultsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ListTagsForResourceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.ListTagsForResource",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ListTagsForResourceRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ListTagsLogGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.ListTagsLogGroup",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ListTagsLogGroupRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutDataProtectionPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutDataProtectionPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutDataProtectionPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutDestinationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutDestination",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutDestinationRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutDestinationPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutDestinationPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutDestinationPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutLogEventsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutLogEvents",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutLogEventsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutMetricFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutMetricFilter",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutMetricFilterRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutQueryDefinitionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutQueryDefinition",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutQueryDefinitionRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutRetentionPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutRetentionPolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutRetentionPolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutSubscriptionFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.PutSubscriptionFilter",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutSubscriptionFilterRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1StartQueryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.StartQuery",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1StartQueryRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1StopQueryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.StopQuery",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1StopQueryRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1TagLogGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.TagLogGroup",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1TagLogGroupRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1TagResourceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.TagResource",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1TagResourceRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1TestMetricFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.TestMetricFilter",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1TestMetricFilterRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1UntagLogGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.UntagLogGroup",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1UntagLogGroupRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1UntagResourceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "Logs_20140328.UntagResource",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1UntagResourceRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const deserializeAws_json1_1AssociateKmsKeyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1AssociateKmsKeyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1AssociateKmsKeyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1CancelExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CancelExportTaskCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CancelExportTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudwatchlogs#InvalidOperationException":
            throw await deserializeAws_json1_1InvalidOperationExceptionResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1CreateExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CreateExportTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1CreateExportTaskResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CreateExportTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceAlreadyExistsException":
        case "com.amazonaws.cloudwatchlogs#ResourceAlreadyExistsException":
            throw await deserializeAws_json1_1ResourceAlreadyExistsExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1CreateLogGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CreateLogGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CreateLogGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceAlreadyExistsException":
        case "com.amazonaws.cloudwatchlogs#ResourceAlreadyExistsException":
            throw await deserializeAws_json1_1ResourceAlreadyExistsExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1CreateLogStreamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CreateLogStreamCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CreateLogStreamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceAlreadyExistsException":
        case "com.amazonaws.cloudwatchlogs#ResourceAlreadyExistsException":
            throw await deserializeAws_json1_1ResourceAlreadyExistsExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteDataProtectionPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteDataProtectionPolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteDataProtectionPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteDestinationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteDestinationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteDestinationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteLogGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteLogGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteLogGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteLogStreamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteLogStreamCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteLogStreamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteMetricFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteMetricFilterCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteMetricFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteQueryDefinitionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteQueryDefinitionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DeleteQueryDefinitionResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteQueryDefinitionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteResourcePolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteRetentionPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteRetentionPolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteRetentionPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteSubscriptionFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteSubscriptionFilterCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteSubscriptionFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeDestinationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeDestinationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeDestinationsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeDestinationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeExportTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeExportTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeExportTasksResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeExportTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeLogGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeLogGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeLogGroupsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeLogGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeLogStreamsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeLogStreamsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeLogStreamsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeLogStreamsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeMetricFiltersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeMetricFiltersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeMetricFiltersResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeMetricFiltersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeQueriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeQueriesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeQueriesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeQueriesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeQueryDefinitionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeQueryDefinitionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeQueryDefinitionsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeQueryDefinitionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeResourcePoliciesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeResourcePoliciesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeResourcePoliciesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeResourcePoliciesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeSubscriptionFiltersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeSubscriptionFiltersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeSubscriptionFiltersResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeSubscriptionFiltersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DisassociateKmsKeyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DisassociateKmsKeyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DisassociateKmsKeyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1FilterLogEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1FilterLogEventsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1FilterLogEventsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1FilterLogEventsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetDataProtectionPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetDataProtectionPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetDataProtectionPolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetDataProtectionPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetLogEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetLogEventsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetLogEventsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetLogEventsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetLogGroupFieldsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetLogGroupFieldsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetLogGroupFieldsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetLogGroupFieldsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetLogRecordCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetLogRecordCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetLogRecordResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetLogRecordCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetQueryResultsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetQueryResultsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetQueryResultsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetQueryResultsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ListTagsForResourceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ListTagsForResourceResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ListTagsLogGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ListTagsLogGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ListTagsLogGroupResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ListTagsLogGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutDataProtectionPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutDataProtectionPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutDataProtectionPolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutDataProtectionPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutDestinationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutDestinationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutDestinationResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutDestinationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutDestinationPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutDestinationPolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutDestinationPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutLogEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutLogEventsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutLogEventsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutLogEventsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DataAlreadyAcceptedException":
        case "com.amazonaws.cloudwatchlogs#DataAlreadyAcceptedException":
            throw await deserializeAws_json1_1DataAlreadyAcceptedExceptionResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidSequenceTokenException":
        case "com.amazonaws.cloudwatchlogs#InvalidSequenceTokenException":
            throw await deserializeAws_json1_1InvalidSequenceTokenExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnrecognizedClientException":
        case "com.amazonaws.cloudwatchlogs#UnrecognizedClientException":
            throw await deserializeAws_json1_1UnrecognizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutMetricFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutMetricFilterCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutMetricFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutQueryDefinitionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutQueryDefinitionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutQueryDefinitionResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutQueryDefinitionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutResourcePolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutResourcePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutRetentionPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutRetentionPolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutRetentionPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutSubscriptionFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutSubscriptionFilterCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutSubscriptionFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "OperationAbortedException":
        case "com.amazonaws.cloudwatchlogs#OperationAbortedException":
            throw await deserializeAws_json1_1OperationAbortedExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1StartQueryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1StartQueryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1StartQueryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1StartQueryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudwatchlogs#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "MalformedQueryException":
        case "com.amazonaws.cloudwatchlogs#MalformedQueryException":
            throw await deserializeAws_json1_1MalformedQueryExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1StopQueryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1StopQueryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1StopQueryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1StopQueryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1TagLogGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1TagLogGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1TagLogGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1TagResourceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "TooManyTagsException":
        case "com.amazonaws.cloudwatchlogs#TooManyTagsException":
            throw await deserializeAws_json1_1TooManyTagsExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1TestMetricFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1TestMetricFilterCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1TestMetricFilterResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1TestMetricFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1UntagLogGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1UntagLogGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1UntagLogGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1UntagResourceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.cloudwatchlogs#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.cloudwatchlogs#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.cloudwatchlogs#ServiceUnavailableException":
            throw await deserializeAws_json1_1ServiceUnavailableExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
const deserializeAws_json1_1DataAlreadyAcceptedExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1DataAlreadyAcceptedException(body, context);
    const exception = new DataAlreadyAcceptedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidOperationExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidOperationException(body, context);
    const exception = new InvalidOperationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidParameterExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidParameterException(body, context);
    const exception = new InvalidParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidSequenceTokenExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidSequenceTokenException(body, context);
    const exception = new InvalidSequenceTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1LimitExceededExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1LimitExceededException(body, context);
    const exception = new LimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1MalformedQueryExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1MalformedQueryException(body, context);
    const exception = new MalformedQueryException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1OperationAbortedExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1OperationAbortedException(body, context);
    const exception = new OperationAbortedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1ResourceAlreadyExistsExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1ResourceAlreadyExistsException(body, context);
    const exception = new ResourceAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1ResourceNotFoundExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1ResourceNotFoundException(body, context);
    const exception = new ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1ServiceUnavailableExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1ServiceUnavailableException(body, context);
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1TooManyTagsExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1TooManyTagsException(body, context);
    const exception = new TooManyTagsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1UnrecognizedClientExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1UnrecognizedClientException(body, context);
    const exception = new UnrecognizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const serializeAws_json1_1AccountIds = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1AssociateKmsKeyRequest = (input, context) => {
    return {
        ...(input.kmsKeyId != null && { kmsKeyId: input.kmsKeyId }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1CancelExportTaskRequest = (input, context) => {
    return {
        ...(input.taskId != null && { taskId: input.taskId }),
    };
};
const serializeAws_json1_1CreateExportTaskRequest = (input, context) => {
    return {
        ...(input.destination != null && { destination: input.destination }),
        ...(input.destinationPrefix != null && { destinationPrefix: input.destinationPrefix }),
        ...(input.from != null && { from: input.from }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamNamePrefix != null && { logStreamNamePrefix: input.logStreamNamePrefix }),
        ...(input.taskName != null && { taskName: input.taskName }),
        ...(input.to != null && { to: input.to }),
    };
};
const serializeAws_json1_1CreateLogGroupRequest = (input, context) => {
    return {
        ...(input.kmsKeyId != null && { kmsKeyId: input.kmsKeyId }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.tags != null && { tags: serializeAws_json1_1Tags(input.tags, context) }),
    };
};
const serializeAws_json1_1CreateLogStreamRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamName != null && { logStreamName: input.logStreamName }),
    };
};
const serializeAws_json1_1DeleteDataProtectionPolicyRequest = (input, context) => {
    return {
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
    };
};
const serializeAws_json1_1DeleteDestinationRequest = (input, context) => {
    return {
        ...(input.destinationName != null && { destinationName: input.destinationName }),
    };
};
const serializeAws_json1_1DeleteLogGroupRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1DeleteLogStreamRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamName != null && { logStreamName: input.logStreamName }),
    };
};
const serializeAws_json1_1DeleteMetricFilterRequest = (input, context) => {
    return {
        ...(input.filterName != null && { filterName: input.filterName }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1DeleteQueryDefinitionRequest = (input, context) => {
    return {
        ...(input.queryDefinitionId != null && { queryDefinitionId: input.queryDefinitionId }),
    };
};
const serializeAws_json1_1DeleteResourcePolicyRequest = (input, context) => {
    return {
        ...(input.policyName != null && { policyName: input.policyName }),
    };
};
const serializeAws_json1_1DeleteRetentionPolicyRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1DeleteSubscriptionFilterRequest = (input, context) => {
    return {
        ...(input.filterName != null && { filterName: input.filterName }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1DescribeDestinationsRequest = (input, context) => {
    return {
        ...(input.DestinationNamePrefix != null && { DestinationNamePrefix: input.DestinationNamePrefix }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
    };
};
const serializeAws_json1_1DescribeExportTasksRequest = (input, context) => {
    return {
        ...(input.limit != null && { limit: input.limit }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.statusCode != null && { statusCode: input.statusCode }),
        ...(input.taskId != null && { taskId: input.taskId }),
    };
};
const serializeAws_json1_1DescribeLogGroupsRequest = (input, context) => {
    return {
        ...(input.accountIdentifiers != null && {
            accountIdentifiers: serializeAws_json1_1AccountIds(input.accountIdentifiers, context),
        }),
        ...(input.includeLinkedAccounts != null && { includeLinkedAccounts: input.includeLinkedAccounts }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupNamePattern != null && { logGroupNamePattern: input.logGroupNamePattern }),
        ...(input.logGroupNamePrefix != null && { logGroupNamePrefix: input.logGroupNamePrefix }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
    };
};
const serializeAws_json1_1DescribeLogStreamsRequest = (input, context) => {
    return {
        ...(input.descending != null && { descending: input.descending }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamNamePrefix != null && { logStreamNamePrefix: input.logStreamNamePrefix }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.orderBy != null && { orderBy: input.orderBy }),
    };
};
const serializeAws_json1_1DescribeMetricFiltersRequest = (input, context) => {
    return {
        ...(input.filterNamePrefix != null && { filterNamePrefix: input.filterNamePrefix }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.metricName != null && { metricName: input.metricName }),
        ...(input.metricNamespace != null && { metricNamespace: input.metricNamespace }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
    };
};
const serializeAws_json1_1DescribeQueriesRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.maxResults != null && { maxResults: input.maxResults }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.status != null && { status: input.status }),
    };
};
const serializeAws_json1_1DescribeQueryDefinitionsRequest = (input, context) => {
    return {
        ...(input.maxResults != null && { maxResults: input.maxResults }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.queryDefinitionNamePrefix != null && { queryDefinitionNamePrefix: input.queryDefinitionNamePrefix }),
    };
};
const serializeAws_json1_1DescribeResourcePoliciesRequest = (input, context) => {
    return {
        ...(input.limit != null && { limit: input.limit }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
    };
};
const serializeAws_json1_1DescribeSubscriptionFiltersRequest = (input, context) => {
    return {
        ...(input.filterNamePrefix != null && { filterNamePrefix: input.filterNamePrefix }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
    };
};
const serializeAws_json1_1Dimensions = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const serializeAws_json1_1DisassociateKmsKeyRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1FilterLogEventsRequest = (input, context) => {
    return {
        ...(input.endTime != null && { endTime: input.endTime }),
        ...(input.filterPattern != null && { filterPattern: input.filterPattern }),
        ...(input.interleaved != null && { interleaved: input.interleaved }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamNamePrefix != null && { logStreamNamePrefix: input.logStreamNamePrefix }),
        ...(input.logStreamNames != null && {
            logStreamNames: serializeAws_json1_1InputLogStreamNames(input.logStreamNames, context),
        }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.startTime != null && { startTime: input.startTime }),
        ...(input.unmask != null && { unmask: input.unmask }),
    };
};
const serializeAws_json1_1GetDataProtectionPolicyRequest = (input, context) => {
    return {
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
    };
};
const serializeAws_json1_1GetLogEventsRequest = (input, context) => {
    return {
        ...(input.endTime != null && { endTime: input.endTime }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamName != null && { logStreamName: input.logStreamName }),
        ...(input.nextToken != null && { nextToken: input.nextToken }),
        ...(input.startFromHead != null && { startFromHead: input.startFromHead }),
        ...(input.startTime != null && { startTime: input.startTime }),
        ...(input.unmask != null && { unmask: input.unmask }),
    };
};
const serializeAws_json1_1GetLogGroupFieldsRequest = (input, context) => {
    return {
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.time != null && { time: input.time }),
    };
};
const serializeAws_json1_1GetLogRecordRequest = (input, context) => {
    return {
        ...(input.logRecordPointer != null && { logRecordPointer: input.logRecordPointer }),
        ...(input.unmask != null && { unmask: input.unmask }),
    };
};
const serializeAws_json1_1GetQueryResultsRequest = (input, context) => {
    return {
        ...(input.queryId != null && { queryId: input.queryId }),
    };
};
const serializeAws_json1_1InputLogEvent = (input, context) => {
    return {
        ...(input.message != null && { message: input.message }),
        ...(input.timestamp != null && { timestamp: input.timestamp }),
    };
};
const serializeAws_json1_1InputLogEvents = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_json1_1InputLogEvent(entry, context);
    });
};
const serializeAws_json1_1InputLogStreamNames = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1ListTagsForResourceRequest = (input, context) => {
    return {
        ...(input.resourceArn != null && { resourceArn: input.resourceArn }),
    };
};
const serializeAws_json1_1ListTagsLogGroupRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
    };
};
const serializeAws_json1_1LogGroupIdentifiers = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1LogGroupNames = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1MetricTransformation = (input, context) => {
    return {
        ...(input.defaultValue != null && { defaultValue: __serializeFloat(input.defaultValue) }),
        ...(input.dimensions != null && { dimensions: serializeAws_json1_1Dimensions(input.dimensions, context) }),
        ...(input.metricName != null && { metricName: input.metricName }),
        ...(input.metricNamespace != null && { metricNamespace: input.metricNamespace }),
        ...(input.metricValue != null && { metricValue: input.metricValue }),
        ...(input.unit != null && { unit: input.unit }),
    };
};
const serializeAws_json1_1MetricTransformations = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_json1_1MetricTransformation(entry, context);
    });
};
const serializeAws_json1_1PutDataProtectionPolicyRequest = (input, context) => {
    return {
        ...(input.logGroupIdentifier != null && { logGroupIdentifier: input.logGroupIdentifier }),
        ...(input.policyDocument != null && { policyDocument: input.policyDocument }),
    };
};
const serializeAws_json1_1PutDestinationPolicyRequest = (input, context) => {
    return {
        ...(input.accessPolicy != null && { accessPolicy: input.accessPolicy }),
        ...(input.destinationName != null && { destinationName: input.destinationName }),
        ...(input.forceUpdate != null && { forceUpdate: input.forceUpdate }),
    };
};
const serializeAws_json1_1PutDestinationRequest = (input, context) => {
    return {
        ...(input.destinationName != null && { destinationName: input.destinationName }),
        ...(input.roleArn != null && { roleArn: input.roleArn }),
        ...(input.tags != null && { tags: serializeAws_json1_1Tags(input.tags, context) }),
        ...(input.targetArn != null && { targetArn: input.targetArn }),
    };
};
const serializeAws_json1_1PutLogEventsRequest = (input, context) => {
    return {
        ...(input.logEvents != null && { logEvents: serializeAws_json1_1InputLogEvents(input.logEvents, context) }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logStreamName != null && { logStreamName: input.logStreamName }),
        ...(input.sequenceToken != null && { sequenceToken: input.sequenceToken }),
    };
};
const serializeAws_json1_1PutMetricFilterRequest = (input, context) => {
    return {
        ...(input.filterName != null && { filterName: input.filterName }),
        ...(input.filterPattern != null && { filterPattern: input.filterPattern }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.metricTransformations != null && {
            metricTransformations: serializeAws_json1_1MetricTransformations(input.metricTransformations, context),
        }),
    };
};
const serializeAws_json1_1PutQueryDefinitionRequest = (input, context) => {
    return {
        ...(input.logGroupNames != null && {
            logGroupNames: serializeAws_json1_1LogGroupNames(input.logGroupNames, context),
        }),
        ...(input.name != null && { name: input.name }),
        ...(input.queryDefinitionId != null && { queryDefinitionId: input.queryDefinitionId }),
        ...(input.queryString != null && { queryString: input.queryString }),
    };
};
const serializeAws_json1_1PutResourcePolicyRequest = (input, context) => {
    return {
        ...(input.policyDocument != null && { policyDocument: input.policyDocument }),
        ...(input.policyName != null && { policyName: input.policyName }),
    };
};
const serializeAws_json1_1PutRetentionPolicyRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.retentionInDays != null && { retentionInDays: input.retentionInDays }),
    };
};
const serializeAws_json1_1PutSubscriptionFilterRequest = (input, context) => {
    return {
        ...(input.destinationArn != null && { destinationArn: input.destinationArn }),
        ...(input.distribution != null && { distribution: input.distribution }),
        ...(input.filterName != null && { filterName: input.filterName }),
        ...(input.filterPattern != null && { filterPattern: input.filterPattern }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.roleArn != null && { roleArn: input.roleArn }),
    };
};
const serializeAws_json1_1StartQueryRequest = (input, context) => {
    return {
        ...(input.endTime != null && { endTime: input.endTime }),
        ...(input.limit != null && { limit: input.limit }),
        ...(input.logGroupIdentifiers != null && {
            logGroupIdentifiers: serializeAws_json1_1LogGroupIdentifiers(input.logGroupIdentifiers, context),
        }),
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.logGroupNames != null && {
            logGroupNames: serializeAws_json1_1LogGroupNames(input.logGroupNames, context),
        }),
        ...(input.queryString != null && { queryString: input.queryString }),
        ...(input.startTime != null && { startTime: input.startTime }),
    };
};
const serializeAws_json1_1StopQueryRequest = (input, context) => {
    return {
        ...(input.queryId != null && { queryId: input.queryId }),
    };
};
const serializeAws_json1_1TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1TagLogGroupRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.tags != null && { tags: serializeAws_json1_1Tags(input.tags, context) }),
    };
};
const serializeAws_json1_1TagResourceRequest = (input, context) => {
    return {
        ...(input.resourceArn != null && { resourceArn: input.resourceArn }),
        ...(input.tags != null && { tags: serializeAws_json1_1Tags(input.tags, context) }),
    };
};
const serializeAws_json1_1Tags = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const serializeAws_json1_1TestEventMessages = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1TestMetricFilterRequest = (input, context) => {
    return {
        ...(input.filterPattern != null && { filterPattern: input.filterPattern }),
        ...(input.logEventMessages != null && {
            logEventMessages: serializeAws_json1_1TestEventMessages(input.logEventMessages, context),
        }),
    };
};
const serializeAws_json1_1UntagLogGroupRequest = (input, context) => {
    return {
        ...(input.logGroupName != null && { logGroupName: input.logGroupName }),
        ...(input.tags != null && { tags: serializeAws_json1_1TagList(input.tags, context) }),
    };
};
const serializeAws_json1_1UntagResourceRequest = (input, context) => {
    return {
        ...(input.resourceArn != null && { resourceArn: input.resourceArn }),
        ...(input.tagKeys != null && { tagKeys: serializeAws_json1_1TagKeyList(input.tagKeys, context) }),
    };
};
const deserializeAws_json1_1CreateExportTaskResponse = (output, context) => {
    return {
        taskId: __expectString(output.taskId),
    };
};
const deserializeAws_json1_1DataAlreadyAcceptedException = (output, context) => {
    return {
        expectedSequenceToken: __expectString(output.expectedSequenceToken),
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1DeleteQueryDefinitionResponse = (output, context) => {
    return {
        success: __expectBoolean(output.success),
    };
};
const deserializeAws_json1_1DescribeDestinationsResponse = (output, context) => {
    return {
        destinations: output.destinations != null ? deserializeAws_json1_1Destinations(output.destinations, context) : undefined,
        nextToken: __expectString(output.nextToken),
    };
};
const deserializeAws_json1_1DescribeExportTasksResponse = (output, context) => {
    return {
        exportTasks: output.exportTasks != null ? deserializeAws_json1_1ExportTasks(output.exportTasks, context) : undefined,
        nextToken: __expectString(output.nextToken),
    };
};
const deserializeAws_json1_1DescribeLogGroupsResponse = (output, context) => {
    return {
        logGroups: output.logGroups != null ? deserializeAws_json1_1LogGroups(output.logGroups, context) : undefined,
        nextToken: __expectString(output.nextToken),
    };
};
const deserializeAws_json1_1DescribeLogStreamsResponse = (output, context) => {
    return {
        logStreams: output.logStreams != null ? deserializeAws_json1_1LogStreams(output.logStreams, context) : undefined,
        nextToken: __expectString(output.nextToken),
    };
};
const deserializeAws_json1_1DescribeMetricFiltersResponse = (output, context) => {
    return {
        metricFilters: output.metricFilters != null ? deserializeAws_json1_1MetricFilters(output.metricFilters, context) : undefined,
        nextToken: __expectString(output.nextToken),
    };
};
const deserializeAws_json1_1DescribeQueriesResponse = (output, context) => {
    return {
        nextToken: __expectString(output.nextToken),
        queries: output.queries != null ? deserializeAws_json1_1QueryInfoList(output.queries, context) : undefined,
    };
};
const deserializeAws_json1_1DescribeQueryDefinitionsResponse = (output, context) => {
    return {
        nextToken: __expectString(output.nextToken),
        queryDefinitions: output.queryDefinitions != null
            ? deserializeAws_json1_1QueryDefinitionList(output.queryDefinitions, context)
            : undefined,
    };
};
const deserializeAws_json1_1DescribeResourcePoliciesResponse = (output, context) => {
    return {
        nextToken: __expectString(output.nextToken),
        resourcePolicies: output.resourcePolicies != null
            ? deserializeAws_json1_1ResourcePolicies(output.resourcePolicies, context)
            : undefined,
    };
};
const deserializeAws_json1_1DescribeSubscriptionFiltersResponse = (output, context) => {
    return {
        nextToken: __expectString(output.nextToken),
        subscriptionFilters: output.subscriptionFilters != null
            ? deserializeAws_json1_1SubscriptionFilters(output.subscriptionFilters, context)
            : undefined,
    };
};
const deserializeAws_json1_1Destination = (output, context) => {
    return {
        accessPolicy: __expectString(output.accessPolicy),
        arn: __expectString(output.arn),
        creationTime: __expectLong(output.creationTime),
        destinationName: __expectString(output.destinationName),
        roleArn: __expectString(output.roleArn),
        targetArn: __expectString(output.targetArn),
    };
};
const deserializeAws_json1_1Destinations = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1Destination(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1Dimensions = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = __expectString(value);
        return acc;
    }, {});
};
const deserializeAws_json1_1ExportTask = (output, context) => {
    return {
        destination: __expectString(output.destination),
        destinationPrefix: __expectString(output.destinationPrefix),
        executionInfo: output.executionInfo != null
            ? deserializeAws_json1_1ExportTaskExecutionInfo(output.executionInfo, context)
            : undefined,
        from: __expectLong(output.from),
        logGroupName: __expectString(output.logGroupName),
        status: output.status != null ? deserializeAws_json1_1ExportTaskStatus(output.status, context) : undefined,
        taskId: __expectString(output.taskId),
        taskName: __expectString(output.taskName),
        to: __expectLong(output.to),
    };
};
const deserializeAws_json1_1ExportTaskExecutionInfo = (output, context) => {
    return {
        completionTime: __expectLong(output.completionTime),
        creationTime: __expectLong(output.creationTime),
    };
};
const deserializeAws_json1_1ExportTasks = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ExportTask(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1ExportTaskStatus = (output, context) => {
    return {
        code: __expectString(output.code),
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1ExtractedValues = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = __expectString(value);
        return acc;
    }, {});
};
const deserializeAws_json1_1FilteredLogEvent = (output, context) => {
    return {
        eventId: __expectString(output.eventId),
        ingestionTime: __expectLong(output.ingestionTime),
        logStreamName: __expectString(output.logStreamName),
        message: __expectString(output.message),
        timestamp: __expectLong(output.timestamp),
    };
};
const deserializeAws_json1_1FilteredLogEvents = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1FilteredLogEvent(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1FilterLogEventsResponse = (output, context) => {
    return {
        events: output.events != null ? deserializeAws_json1_1FilteredLogEvents(output.events, context) : undefined,
        nextToken: __expectString(output.nextToken),
        searchedLogStreams: output.searchedLogStreams != null
            ? deserializeAws_json1_1SearchedLogStreams(output.searchedLogStreams, context)
            : undefined,
    };
};
const deserializeAws_json1_1GetDataProtectionPolicyResponse = (output, context) => {
    return {
        lastUpdatedTime: __expectLong(output.lastUpdatedTime),
        logGroupIdentifier: __expectString(output.logGroupIdentifier),
        policyDocument: __expectString(output.policyDocument),
    };
};
const deserializeAws_json1_1GetLogEventsResponse = (output, context) => {
    return {
        events: output.events != null ? deserializeAws_json1_1OutputLogEvents(output.events, context) : undefined,
        nextBackwardToken: __expectString(output.nextBackwardToken),
        nextForwardToken: __expectString(output.nextForwardToken),
    };
};
const deserializeAws_json1_1GetLogGroupFieldsResponse = (output, context) => {
    return {
        logGroupFields: output.logGroupFields != null
            ? deserializeAws_json1_1LogGroupFieldList(output.logGroupFields, context)
            : undefined,
    };
};
const deserializeAws_json1_1GetLogRecordResponse = (output, context) => {
    return {
        logRecord: output.logRecord != null ? deserializeAws_json1_1LogRecord(output.logRecord, context) : undefined,
    };
};
const deserializeAws_json1_1GetQueryResultsResponse = (output, context) => {
    return {
        results: output.results != null ? deserializeAws_json1_1QueryResults(output.results, context) : undefined,
        statistics: output.statistics != null ? deserializeAws_json1_1QueryStatistics(output.statistics, context) : undefined,
        status: __expectString(output.status),
    };
};
const deserializeAws_json1_1InvalidOperationException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1InvalidParameterException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1InvalidSequenceTokenException = (output, context) => {
    return {
        expectedSequenceToken: __expectString(output.expectedSequenceToken),
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1LimitExceededException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1ListTagsForResourceResponse = (output, context) => {
    return {
        tags: output.tags != null ? deserializeAws_json1_1Tags(output.tags, context) : undefined,
    };
};
const deserializeAws_json1_1ListTagsLogGroupResponse = (output, context) => {
    return {
        tags: output.tags != null ? deserializeAws_json1_1Tags(output.tags, context) : undefined,
    };
};
const deserializeAws_json1_1LogGroup = (output, context) => {
    return {
        arn: __expectString(output.arn),
        creationTime: __expectLong(output.creationTime),
        dataProtectionStatus: __expectString(output.dataProtectionStatus),
        kmsKeyId: __expectString(output.kmsKeyId),
        logGroupName: __expectString(output.logGroupName),
        metricFilterCount: __expectInt32(output.metricFilterCount),
        retentionInDays: __expectInt32(output.retentionInDays),
        storedBytes: __expectLong(output.storedBytes),
    };
};
const deserializeAws_json1_1LogGroupField = (output, context) => {
    return {
        name: __expectString(output.name),
        percent: __expectInt32(output.percent),
    };
};
const deserializeAws_json1_1LogGroupFieldList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1LogGroupField(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1LogGroupNames = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_json1_1LogGroups = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1LogGroup(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1LogRecord = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = __expectString(value);
        return acc;
    }, {});
};
const deserializeAws_json1_1LogStream = (output, context) => {
    return {
        arn: __expectString(output.arn),
        creationTime: __expectLong(output.creationTime),
        firstEventTimestamp: __expectLong(output.firstEventTimestamp),
        lastEventTimestamp: __expectLong(output.lastEventTimestamp),
        lastIngestionTime: __expectLong(output.lastIngestionTime),
        logStreamName: __expectString(output.logStreamName),
        storedBytes: __expectLong(output.storedBytes),
        uploadSequenceToken: __expectString(output.uploadSequenceToken),
    };
};
const deserializeAws_json1_1LogStreams = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1LogStream(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1MalformedQueryException = (output, context) => {
    return {
        message: __expectString(output.message),
        queryCompileError: output.queryCompileError != null
            ? deserializeAws_json1_1QueryCompileError(output.queryCompileError, context)
            : undefined,
    };
};
const deserializeAws_json1_1MetricFilter = (output, context) => {
    return {
        creationTime: __expectLong(output.creationTime),
        filterName: __expectString(output.filterName),
        filterPattern: __expectString(output.filterPattern),
        logGroupName: __expectString(output.logGroupName),
        metricTransformations: output.metricTransformations != null
            ? deserializeAws_json1_1MetricTransformations(output.metricTransformations, context)
            : undefined,
    };
};
const deserializeAws_json1_1MetricFilterMatches = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1MetricFilterMatchRecord(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1MetricFilterMatchRecord = (output, context) => {
    return {
        eventMessage: __expectString(output.eventMessage),
        eventNumber: __expectLong(output.eventNumber),
        extractedValues: output.extractedValues != null
            ? deserializeAws_json1_1ExtractedValues(output.extractedValues, context)
            : undefined,
    };
};
const deserializeAws_json1_1MetricFilters = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1MetricFilter(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1MetricTransformation = (output, context) => {
    return {
        defaultValue: __limitedParseDouble(output.defaultValue),
        dimensions: output.dimensions != null ? deserializeAws_json1_1Dimensions(output.dimensions, context) : undefined,
        metricName: __expectString(output.metricName),
        metricNamespace: __expectString(output.metricNamespace),
        metricValue: __expectString(output.metricValue),
        unit: __expectString(output.unit),
    };
};
const deserializeAws_json1_1MetricTransformations = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1MetricTransformation(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1OperationAbortedException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1OutputLogEvent = (output, context) => {
    return {
        ingestionTime: __expectLong(output.ingestionTime),
        message: __expectString(output.message),
        timestamp: __expectLong(output.timestamp),
    };
};
const deserializeAws_json1_1OutputLogEvents = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1OutputLogEvent(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1PutDataProtectionPolicyResponse = (output, context) => {
    return {
        lastUpdatedTime: __expectLong(output.lastUpdatedTime),
        logGroupIdentifier: __expectString(output.logGroupIdentifier),
        policyDocument: __expectString(output.policyDocument),
    };
};
const deserializeAws_json1_1PutDestinationResponse = (output, context) => {
    return {
        destination: output.destination != null ? deserializeAws_json1_1Destination(output.destination, context) : undefined,
    };
};
const deserializeAws_json1_1PutLogEventsResponse = (output, context) => {
    return {
        nextSequenceToken: __expectString(output.nextSequenceToken),
        rejectedLogEventsInfo: output.rejectedLogEventsInfo != null
            ? deserializeAws_json1_1RejectedLogEventsInfo(output.rejectedLogEventsInfo, context)
            : undefined,
    };
};
const deserializeAws_json1_1PutQueryDefinitionResponse = (output, context) => {
    return {
        queryDefinitionId: __expectString(output.queryDefinitionId),
    };
};
const deserializeAws_json1_1PutResourcePolicyResponse = (output, context) => {
    return {
        resourcePolicy: output.resourcePolicy != null ? deserializeAws_json1_1ResourcePolicy(output.resourcePolicy, context) : undefined,
    };
};
const deserializeAws_json1_1QueryCompileError = (output, context) => {
    return {
        location: output.location != null ? deserializeAws_json1_1QueryCompileErrorLocation(output.location, context) : undefined,
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1QueryCompileErrorLocation = (output, context) => {
    return {
        endCharOffset: __expectInt32(output.endCharOffset),
        startCharOffset: __expectInt32(output.startCharOffset),
    };
};
const deserializeAws_json1_1QueryDefinition = (output, context) => {
    return {
        lastModified: __expectLong(output.lastModified),
        logGroupNames: output.logGroupNames != null ? deserializeAws_json1_1LogGroupNames(output.logGroupNames, context) : undefined,
        name: __expectString(output.name),
        queryDefinitionId: __expectString(output.queryDefinitionId),
        queryString: __expectString(output.queryString),
    };
};
const deserializeAws_json1_1QueryDefinitionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1QueryDefinition(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1QueryInfo = (output, context) => {
    return {
        createTime: __expectLong(output.createTime),
        logGroupName: __expectString(output.logGroupName),
        queryId: __expectString(output.queryId),
        queryString: __expectString(output.queryString),
        status: __expectString(output.status),
    };
};
const deserializeAws_json1_1QueryInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1QueryInfo(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1QueryResults = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ResultRows(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1QueryStatistics = (output, context) => {
    return {
        bytesScanned: __limitedParseDouble(output.bytesScanned),
        recordsMatched: __limitedParseDouble(output.recordsMatched),
        recordsScanned: __limitedParseDouble(output.recordsScanned),
    };
};
const deserializeAws_json1_1RejectedLogEventsInfo = (output, context) => {
    return {
        expiredLogEventEndIndex: __expectInt32(output.expiredLogEventEndIndex),
        tooNewLogEventStartIndex: __expectInt32(output.tooNewLogEventStartIndex),
        tooOldLogEventEndIndex: __expectInt32(output.tooOldLogEventEndIndex),
    };
};
const deserializeAws_json1_1ResourceAlreadyExistsException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1ResourceNotFoundException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1ResourcePolicies = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ResourcePolicy(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1ResourcePolicy = (output, context) => {
    return {
        lastUpdatedTime: __expectLong(output.lastUpdatedTime),
        policyDocument: __expectString(output.policyDocument),
        policyName: __expectString(output.policyName),
    };
};
const deserializeAws_json1_1ResultField = (output, context) => {
    return {
        field: __expectString(output.field),
        value: __expectString(output.value),
    };
};
const deserializeAws_json1_1ResultRows = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ResultField(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1SearchedLogStream = (output, context) => {
    return {
        logStreamName: __expectString(output.logStreamName),
        searchedCompletely: __expectBoolean(output.searchedCompletely),
    };
};
const deserializeAws_json1_1SearchedLogStreams = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SearchedLogStream(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1ServiceUnavailableException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeAws_json1_1StartQueryResponse = (output, context) => {
    return {
        queryId: __expectString(output.queryId),
    };
};
const deserializeAws_json1_1StopQueryResponse = (output, context) => {
    return {
        success: __expectBoolean(output.success),
    };
};
const deserializeAws_json1_1SubscriptionFilter = (output, context) => {
    return {
        creationTime: __expectLong(output.creationTime),
        destinationArn: __expectString(output.destinationArn),
        distribution: __expectString(output.distribution),
        filterName: __expectString(output.filterName),
        filterPattern: __expectString(output.filterPattern),
        logGroupName: __expectString(output.logGroupName),
        roleArn: __expectString(output.roleArn),
    };
};
const deserializeAws_json1_1SubscriptionFilters = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SubscriptionFilter(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1Tags = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = __expectString(value);
        return acc;
    }, {});
};
const deserializeAws_json1_1TestMetricFilterResponse = (output, context) => {
    return {
        matches: output.matches != null ? deserializeAws_json1_1MetricFilterMatches(output.matches, context) : undefined,
    };
};
const deserializeAws_json1_1TooManyTagsException = (output, context) => {
    return {
        message: __expectString(output.message),
        resourceName: __expectString(output.resourceName),
    };
};
const deserializeAws_json1_1UnrecognizedClientException = (output, context) => {
    return {
        message: __expectString(output.message),
    };
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
