import { CloudWatchLogsServiceException as __BaseException } from "./CloudWatchLogsServiceException";
export class InvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameterException.prototype);
    }
}
export class OperationAbortedException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationAbortedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationAbortedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationAbortedException.prototype);
    }
}
export class ResourceNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
    }
}
export class InvalidOperationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOperationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
    }
}
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
    }
}
export class ResourceAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceAlreadyExistsException.prototype);
    }
}
export class DataAlreadyAcceptedException extends __BaseException {
    constructor(opts) {
        super({
            name: "DataAlreadyAcceptedException",
            $fault: "client",
            ...opts,
        });
        this.name = "DataAlreadyAcceptedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DataAlreadyAcceptedException.prototype);
        this.expectedSequenceToken = opts.expectedSequenceToken;
    }
}
export var DataProtectionStatus;
(function (DataProtectionStatus) {
    DataProtectionStatus["ACTIVATED"] = "ACTIVATED";
    DataProtectionStatus["ARCHIVED"] = "ARCHIVED";
    DataProtectionStatus["DELETED"] = "DELETED";
    DataProtectionStatus["DISABLED"] = "DISABLED";
})(DataProtectionStatus || (DataProtectionStatus = {}));
export var ExportTaskStatusCode;
(function (ExportTaskStatusCode) {
    ExportTaskStatusCode["CANCELLED"] = "CANCELLED";
    ExportTaskStatusCode["COMPLETED"] = "COMPLETED";
    ExportTaskStatusCode["FAILED"] = "FAILED";
    ExportTaskStatusCode["PENDING"] = "PENDING";
    ExportTaskStatusCode["PENDING_CANCEL"] = "PENDING_CANCEL";
    ExportTaskStatusCode["RUNNING"] = "RUNNING";
})(ExportTaskStatusCode || (ExportTaskStatusCode = {}));
export var OrderBy;
(function (OrderBy) {
    OrderBy["LastEventTime"] = "LastEventTime";
    OrderBy["LogStreamName"] = "LogStreamName";
})(OrderBy || (OrderBy = {}));
export var StandardUnit;
(function (StandardUnit) {
    StandardUnit["Bits"] = "Bits";
    StandardUnit["BitsSecond"] = "Bits/Second";
    StandardUnit["Bytes"] = "Bytes";
    StandardUnit["BytesSecond"] = "Bytes/Second";
    StandardUnit["Count"] = "Count";
    StandardUnit["CountSecond"] = "Count/Second";
    StandardUnit["Gigabits"] = "Gigabits";
    StandardUnit["GigabitsSecond"] = "Gigabits/Second";
    StandardUnit["Gigabytes"] = "Gigabytes";
    StandardUnit["GigabytesSecond"] = "Gigabytes/Second";
    StandardUnit["Kilobits"] = "Kilobits";
    StandardUnit["KilobitsSecond"] = "Kilobits/Second";
    StandardUnit["Kilobytes"] = "Kilobytes";
    StandardUnit["KilobytesSecond"] = "Kilobytes/Second";
    StandardUnit["Megabits"] = "Megabits";
    StandardUnit["MegabitsSecond"] = "Megabits/Second";
    StandardUnit["Megabytes"] = "Megabytes";
    StandardUnit["MegabytesSecond"] = "Megabytes/Second";
    StandardUnit["Microseconds"] = "Microseconds";
    StandardUnit["Milliseconds"] = "Milliseconds";
    StandardUnit["None"] = "None";
    StandardUnit["Percent"] = "Percent";
    StandardUnit["Seconds"] = "Seconds";
    StandardUnit["Terabits"] = "Terabits";
    StandardUnit["TerabitsSecond"] = "Terabits/Second";
    StandardUnit["Terabytes"] = "Terabytes";
    StandardUnit["TerabytesSecond"] = "Terabytes/Second";
})(StandardUnit || (StandardUnit = {}));
export var QueryStatus;
(function (QueryStatus) {
    QueryStatus["Cancelled"] = "Cancelled";
    QueryStatus["Complete"] = "Complete";
    QueryStatus["Failed"] = "Failed";
    QueryStatus["Running"] = "Running";
    QueryStatus["Scheduled"] = "Scheduled";
    QueryStatus["Timeout"] = "Timeout";
    QueryStatus["Unknown"] = "Unknown";
})(QueryStatus || (QueryStatus = {}));
export var Distribution;
(function (Distribution) {
    Distribution["ByLogStream"] = "ByLogStream";
    Distribution["Random"] = "Random";
})(Distribution || (Distribution = {}));
export class InvalidSequenceTokenException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSequenceTokenException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSequenceTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSequenceTokenException.prototype);
        this.expectedSequenceToken = opts.expectedSequenceToken;
    }
}
export class UnrecognizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnrecognizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnrecognizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnrecognizedClientException.prototype);
    }
}
export class MalformedQueryException extends __BaseException {
    constructor(opts) {
        super({
            name: "MalformedQueryException",
            $fault: "client",
            ...opts,
        });
        this.name = "MalformedQueryException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MalformedQueryException.prototype);
        this.queryCompileError = opts.queryCompileError;
    }
}
export class TooManyTagsException extends __BaseException {
    constructor(opts) {
        super({
            name: "TooManyTagsException",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsException.prototype);
        this.resourceName = opts.resourceName;
    }
}
export const AssociateKmsKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelExportTaskRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateExportTaskRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateExportTaskResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateLogGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateLogStreamRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteDataProtectionPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteDestinationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteLogGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteLogStreamRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteMetricFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteQueryDefinitionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteQueryDefinitionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRetentionPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSubscriptionFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDestinationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDestinationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeExportTasksRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ExportTaskExecutionInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ExportTaskStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ExportTaskFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeExportTasksResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeLogGroupsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LogGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeLogGroupsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeLogStreamsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LogStreamFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeLogStreamsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMetricFiltersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MetricTransformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MetricFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMetricFiltersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeQueriesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const QueryInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeQueriesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeQueryDefinitionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const QueryDefinitionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeQueryDefinitionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeResourcePoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourcePolicyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeResourcePoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSubscriptionFiltersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SubscriptionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSubscriptionFiltersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociateKmsKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const FilteredLogEventFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const FilterLogEventsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SearchedLogStreamFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const FilterLogEventsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDataProtectionPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDataProtectionPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogEventsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OutputLogEventFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogEventsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogGroupFieldsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LogGroupFieldFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogGroupFieldsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogRecordRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLogRecordResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetQueryResultsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResultFieldFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const QueryStatisticsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetQueryResultsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InputLogEventFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsForResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsForResourceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsLogGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsLogGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutDataProtectionPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutDataProtectionPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutDestinationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutDestinationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutDestinationPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutLogEventsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RejectedLogEventsInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutLogEventsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutMetricFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutQueryDefinitionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutQueryDefinitionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutRetentionPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutSubscriptionFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const QueryCompileErrorLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const QueryCompileErrorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartQueryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartQueryResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopQueryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopQueryResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagLogGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TestMetricFilterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MetricFilterMatchRecordFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TestMetricFilterResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagLogGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
