import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeMetricFiltersRequestFilterSensitiveLog, DescribeMetricFiltersResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DescribeMetricFiltersCommand, serializeAws_json1_1DescribeMetricFiltersCommand, } from "../protocols/Aws_json1_1";
export class DescribeMetricFiltersCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeMetricFiltersCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "CloudWatchLogsClient";
        const commandName = "DescribeMetricFiltersCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeMetricFiltersRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeMetricFiltersResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1DescribeMetricFiltersCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1DescribeMetricFiltersCommand(output, context);
    }
}
