"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogs = void 0;
const CloudWatchLogsClient_1 = require("./CloudWatchLogsClient");
const AssociateKmsKeyCommand_1 = require("./commands/AssociateKmsKeyCommand");
const CancelExportTaskCommand_1 = require("./commands/CancelExportTaskCommand");
const CreateExportTaskCommand_1 = require("./commands/CreateExportTaskCommand");
const CreateLogGroupCommand_1 = require("./commands/CreateLogGroupCommand");
const CreateLogStreamCommand_1 = require("./commands/CreateLogStreamCommand");
const DeleteDataProtectionPolicyCommand_1 = require("./commands/DeleteDataProtectionPolicyCommand");
const DeleteDestinationCommand_1 = require("./commands/DeleteDestinationCommand");
const DeleteLogGroupCommand_1 = require("./commands/DeleteLogGroupCommand");
const DeleteLogStreamCommand_1 = require("./commands/DeleteLogStreamCommand");
const DeleteMetricFilterCommand_1 = require("./commands/DeleteMetricFilterCommand");
const DeleteQueryDefinitionCommand_1 = require("./commands/DeleteQueryDefinitionCommand");
const DeleteResourcePolicyCommand_1 = require("./commands/DeleteResourcePolicyCommand");
const DeleteRetentionPolicyCommand_1 = require("./commands/DeleteRetentionPolicyCommand");
const DeleteSubscriptionFilterCommand_1 = require("./commands/DeleteSubscriptionFilterCommand");
const DescribeDestinationsCommand_1 = require("./commands/DescribeDestinationsCommand");
const DescribeExportTasksCommand_1 = require("./commands/DescribeExportTasksCommand");
const DescribeLogGroupsCommand_1 = require("./commands/DescribeLogGroupsCommand");
const DescribeLogStreamsCommand_1 = require("./commands/DescribeLogStreamsCommand");
const DescribeMetricFiltersCommand_1 = require("./commands/DescribeMetricFiltersCommand");
const DescribeQueriesCommand_1 = require("./commands/DescribeQueriesCommand");
const DescribeQueryDefinitionsCommand_1 = require("./commands/DescribeQueryDefinitionsCommand");
const DescribeResourcePoliciesCommand_1 = require("./commands/DescribeResourcePoliciesCommand");
const DescribeSubscriptionFiltersCommand_1 = require("./commands/DescribeSubscriptionFiltersCommand");
const DisassociateKmsKeyCommand_1 = require("./commands/DisassociateKmsKeyCommand");
const FilterLogEventsCommand_1 = require("./commands/FilterLogEventsCommand");
const GetDataProtectionPolicyCommand_1 = require("./commands/GetDataProtectionPolicyCommand");
const GetLogEventsCommand_1 = require("./commands/GetLogEventsCommand");
const GetLogGroupFieldsCommand_1 = require("./commands/GetLogGroupFieldsCommand");
const GetLogRecordCommand_1 = require("./commands/GetLogRecordCommand");
const GetQueryResultsCommand_1 = require("./commands/GetQueryResultsCommand");
const ListTagsForResourceCommand_1 = require("./commands/ListTagsForResourceCommand");
const ListTagsLogGroupCommand_1 = require("./commands/ListTagsLogGroupCommand");
const PutDataProtectionPolicyCommand_1 = require("./commands/PutDataProtectionPolicyCommand");
const PutDestinationCommand_1 = require("./commands/PutDestinationCommand");
const PutDestinationPolicyCommand_1 = require("./commands/PutDestinationPolicyCommand");
const PutLogEventsCommand_1 = require("./commands/PutLogEventsCommand");
const PutMetricFilterCommand_1 = require("./commands/PutMetricFilterCommand");
const PutQueryDefinitionCommand_1 = require("./commands/PutQueryDefinitionCommand");
const PutResourcePolicyCommand_1 = require("./commands/PutResourcePolicyCommand");
const PutRetentionPolicyCommand_1 = require("./commands/PutRetentionPolicyCommand");
const PutSubscriptionFilterCommand_1 = require("./commands/PutSubscriptionFilterCommand");
const StartQueryCommand_1 = require("./commands/StartQueryCommand");
const StopQueryCommand_1 = require("./commands/StopQueryCommand");
const TagLogGroupCommand_1 = require("./commands/TagLogGroupCommand");
const TagResourceCommand_1 = require("./commands/TagResourceCommand");
const TestMetricFilterCommand_1 = require("./commands/TestMetricFilterCommand");
const UntagLogGroupCommand_1 = require("./commands/UntagLogGroupCommand");
const UntagResourceCommand_1 = require("./commands/UntagResourceCommand");
class CloudWatchLogs extends CloudWatchLogsClient_1.CloudWatchLogsClient {
    associateKmsKey(args, optionsOrCb, cb) {
        const command = new AssociateKmsKeyCommand_1.AssociateKmsKeyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    cancelExportTask(args, optionsOrCb, cb) {
        const command = new CancelExportTaskCommand_1.CancelExportTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createExportTask(args, optionsOrCb, cb) {
        const command = new CreateExportTaskCommand_1.CreateExportTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createLogGroup(args, optionsOrCb, cb) {
        const command = new CreateLogGroupCommand_1.CreateLogGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createLogStream(args, optionsOrCb, cb) {
        const command = new CreateLogStreamCommand_1.CreateLogStreamCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteDataProtectionPolicy(args, optionsOrCb, cb) {
        const command = new DeleteDataProtectionPolicyCommand_1.DeleteDataProtectionPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteDestination(args, optionsOrCb, cb) {
        const command = new DeleteDestinationCommand_1.DeleteDestinationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteLogGroup(args, optionsOrCb, cb) {
        const command = new DeleteLogGroupCommand_1.DeleteLogGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteLogStream(args, optionsOrCb, cb) {
        const command = new DeleteLogStreamCommand_1.DeleteLogStreamCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMetricFilter(args, optionsOrCb, cb) {
        const command = new DeleteMetricFilterCommand_1.DeleteMetricFilterCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteQueryDefinition(args, optionsOrCb, cb) {
        const command = new DeleteQueryDefinitionCommand_1.DeleteQueryDefinitionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteResourcePolicy(args, optionsOrCb, cb) {
        const command = new DeleteResourcePolicyCommand_1.DeleteResourcePolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteRetentionPolicy(args, optionsOrCb, cb) {
        const command = new DeleteRetentionPolicyCommand_1.DeleteRetentionPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteSubscriptionFilter(args, optionsOrCb, cb) {
        const command = new DeleteSubscriptionFilterCommand_1.DeleteSubscriptionFilterCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeDestinations(args, optionsOrCb, cb) {
        const command = new DescribeDestinationsCommand_1.DescribeDestinationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeExportTasks(args, optionsOrCb, cb) {
        const command = new DescribeExportTasksCommand_1.DescribeExportTasksCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeLogGroups(args, optionsOrCb, cb) {
        const command = new DescribeLogGroupsCommand_1.DescribeLogGroupsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeLogStreams(args, optionsOrCb, cb) {
        const command = new DescribeLogStreamsCommand_1.DescribeLogStreamsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeMetricFilters(args, optionsOrCb, cb) {
        const command = new DescribeMetricFiltersCommand_1.DescribeMetricFiltersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeQueries(args, optionsOrCb, cb) {
        const command = new DescribeQueriesCommand_1.DescribeQueriesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeQueryDefinitions(args, optionsOrCb, cb) {
        const command = new DescribeQueryDefinitionsCommand_1.DescribeQueryDefinitionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeResourcePolicies(args, optionsOrCb, cb) {
        const command = new DescribeResourcePoliciesCommand_1.DescribeResourcePoliciesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeSubscriptionFilters(args, optionsOrCb, cb) {
        const command = new DescribeSubscriptionFiltersCommand_1.DescribeSubscriptionFiltersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociateKmsKey(args, optionsOrCb, cb) {
        const command = new DisassociateKmsKeyCommand_1.DisassociateKmsKeyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    filterLogEvents(args, optionsOrCb, cb) {
        const command = new FilterLogEventsCommand_1.FilterLogEventsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDataProtectionPolicy(args, optionsOrCb, cb) {
        const command = new GetDataProtectionPolicyCommand_1.GetDataProtectionPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getLogEvents(args, optionsOrCb, cb) {
        const command = new GetLogEventsCommand_1.GetLogEventsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getLogGroupFields(args, optionsOrCb, cb) {
        const command = new GetLogGroupFieldsCommand_1.GetLogGroupFieldsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getLogRecord(args, optionsOrCb, cb) {
        const command = new GetLogRecordCommand_1.GetLogRecordCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getQueryResults(args, optionsOrCb, cb) {
        const command = new GetQueryResultsCommand_1.GetQueryResultsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand_1.ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsLogGroup(args, optionsOrCb, cb) {
        const command = new ListTagsLogGroupCommand_1.ListTagsLogGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putDataProtectionPolicy(args, optionsOrCb, cb) {
        const command = new PutDataProtectionPolicyCommand_1.PutDataProtectionPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putDestination(args, optionsOrCb, cb) {
        const command = new PutDestinationCommand_1.PutDestinationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putDestinationPolicy(args, optionsOrCb, cb) {
        const command = new PutDestinationPolicyCommand_1.PutDestinationPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putLogEvents(args, optionsOrCb, cb) {
        const command = new PutLogEventsCommand_1.PutLogEventsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putMetricFilter(args, optionsOrCb, cb) {
        const command = new PutMetricFilterCommand_1.PutMetricFilterCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putQueryDefinition(args, optionsOrCb, cb) {
        const command = new PutQueryDefinitionCommand_1.PutQueryDefinitionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putResourcePolicy(args, optionsOrCb, cb) {
        const command = new PutResourcePolicyCommand_1.PutResourcePolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putRetentionPolicy(args, optionsOrCb, cb) {
        const command = new PutRetentionPolicyCommand_1.PutRetentionPolicyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putSubscriptionFilter(args, optionsOrCb, cb) {
        const command = new PutSubscriptionFilterCommand_1.PutSubscriptionFilterCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    startQuery(args, optionsOrCb, cb) {
        const command = new StartQueryCommand_1.StartQueryCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    stopQuery(args, optionsOrCb, cb) {
        const command = new StopQueryCommand_1.StopQueryCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagLogGroup(args, optionsOrCb, cb) {
        const command = new TagLogGroupCommand_1.TagLogGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand_1.TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    testMetricFilter(args, optionsOrCb, cb) {
        const command = new TestMetricFilterCommand_1.TestMetricFilterCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagLogGroup(args, optionsOrCb, cb) {
        const command = new UntagLogGroupCommand_1.UntagLogGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand_1.UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
exports.CloudWatchLogs = CloudWatchLogs;
